/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.googlecode.jatl.Html;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.RelocatingInterceptor;
import com.predic8.membrane.core.ws.relocator.Relocator;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="wadlRewriter")
public class WADLInterceptor
extends RelocatingInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)WADLInterceptor.class.getName());

    public WADLInterceptor() {
        this.name = "wadl rewriting interceptor";
        this.setFlow(Interceptor.Flow.Set.RESPONSE_ABORT_FLOW);
    }

    @Override
    public String getShortDescription() {
        return "Rewrites REST endpoint addresses and XML Schema locations in WADL and XSD documents.";
    }

    @Override
    protected void rewrite(Exchange exc) throws Exception {
        log.debug("Changing endpoint address in WADL");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Relocator relocator = new Relocator(new OutputStreamWriter((OutputStream)stream, exc.getResponse().getCharset()), this.getLocationProtocol(), this.getLocationHost(exc), this.getLocationPort(exc), exc.getHandler().getContextPath(exc), this.pathRewriter);
        relocator.getRelocatingAttributes().put(new QName("http://wadl.dev.java.net/2009/02", "resources"), "base");
        relocator.getRelocatingAttributes().put(new QName("http://wadl.dev.java.net/2009/02", "include"), "href");
        relocator.relocate(new InputStreamReader(exc.getResponse().getBodyAsStreamDecoded(), exc.getResponse().getCharset()));
        exc.getResponse().setBodyContent(stream.toByteArray());
    }

    @Override
    @MCAttribute
    public void setProtocol(String protocol) {
        super.setProtocol(protocol);
    }

    @Override
    @MCAttribute
    public void setHost(String host) {
        super.setHost(host);
    }

    @Override
    @MCAttribute
    public void setPort(String port) {
        super.setPort(port);
    }

    @Override
    public String getLongDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getShortDescription());
        sb.append("<br/>");
        sb.append("The protocol, host and port of the incoming request will be used for the substitution");
        if (this.protocol != null || this.port != null || this.host != null) {
            sb.append(" except the following fixed values:");
            StringWriter sw = new StringWriter();
            new Html(sw){
                {
                    this.table();
                    this.thead();
                    this.tr();
                    ((Html)((Html)this.th()).text("Part")).end();
                    ((Html)((Html)this.th()).text("Value")).end();
                    this.end();
                    this.end();
                    this.tbody();
                    if (WADLInterceptor.this.protocol != null) {
                        this.tr();
                        ((Html)((Html)this.td()).text("Protocol")).end();
                        ((Html)((Html)this.td()).text(WADLInterceptor.this.protocol)).end();
                        this.end();
                    }
                    if (WADLInterceptor.this.host != null) {
                        this.tr();
                        ((Html)((Html)this.td()).text("Host")).end();
                        ((Html)((Html)this.td()).text(WADLInterceptor.this.host)).end();
                        this.end();
                    }
                    if (WADLInterceptor.this.port != null) {
                        this.tr();
                        ((Html)((Html)this.td()).text("Port")).end();
                        ((Html)((Html)this.td()).text(WADLInterceptor.this.port)).end();
                        this.end();
                    }
                    this.end();
                    this.end();
                }
            };
            sb.append(sw);
        } else {
            sb.append(".");
        }
        return sb.toString();
    }
}

