/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.RelocatingInterceptor;
import com.predic8.membrane.core.transport.http.HttpClient;
import com.predic8.membrane.core.util.MessageUtil;
import com.predic8.membrane.core.ws.relocator.Relocator;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import javax.xml.namespace.QName;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="wsdlRewriter")
public class WSDLInterceptor
extends RelocatingInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)WSDLInterceptor.class.getName());
    public static final QName XSD_IMPORT_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "import");
    public static final QName XSD_INCLUDE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "include");
    public static final String LOCATION = "location";
    private String registryWSDLRegisterURL;
    private boolean rewriteEndpoint = true;
    private HttpClient hc;

    public WSDLInterceptor() {
        this.name = "wsdl rewriting";
        this.setFlow(Interceptor.Flow.Set.RESPONSE_FLOW);
    }

    @Override
    public void init() {
        super.init();
        this.hc = this.router.getHttpClientFactory().createClient(null);
    }

    @Override
    protected void rewrite(Exchange exc) throws Exception {
        log.debug("Changing endpoint address in WSDL");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Relocator relocator = this.getRelocator(exc, stream);
        relocator.relocate(new InputStreamReader(exc.getResponse().getBodyAsStreamDecoded(), exc.getResponse().getCharset()));
        if (relocator.isWsdlFound()) {
            this.registerWSDL(exc);
        }
        exc.getResponse().setBodyContent(stream.toByteArray());
    }

    @NotNull
    private Relocator getRelocator(Exchange exc, OutputStream stream) throws Exception {
        Relocator relocator = new Relocator(new OutputStreamWriter(stream, exc.getResponse().getCharset()), this.getLocationProtocol(), this.getLocationHost(exc), this.getLocationPort(exc), exc.getHandler().getContextPath(exc), this.pathRewriter);
        if (this.rewriteEndpoint) {
            relocator.getRelocatingAttributes().put(Constants.WSDL11_ADDRESS_SOAP11, LOCATION);
            relocator.getRelocatingAttributes().put(Constants.WSDL11_ADDRESS_SOAP12, LOCATION);
            relocator.getRelocatingAttributes().put(Constants.WSDL11_ADDRESS_HTTP, LOCATION);
        }
        relocator.getRelocatingAttributes().put(XSD_IMPORT_QNAME, "schemaLocation");
        relocator.getRelocatingAttributes().put(XSD_INCLUDE_QNAME, "schemaLocation");
        return relocator;
    }

    private void registerWSDL(Exchange exc) {
        if (this.registryWSDLRegisterURL == null) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(this.registryWSDLRegisterURL);
        buf.append("?wsdl=");
        buf.append(URLDecoder.decode(this.getWSDLURL(exc), StandardCharsets.US_ASCII));
        this.callRegistry(buf.toString());
        log.debug(buf.toString());
    }

    private void callRegistry(String uri) {
        try {
            Response res = this.hc.call(this.createExchange(uri)).getResponse();
            if (res.getStatusCode() != 200) {
                log.warn("{}", (Object)res);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    private Exchange createExchange(String uri) throws MalformedURLException {
        URL url = new URL(uri);
        Request req = MessageUtil.getGetRequest(this.getCompletePath(url));
        req.getHeader().setHost(url.getHost());
        Exchange exc = new Exchange(null);
        exc.setRequest(req);
        exc.getDestinations().add(uri);
        return exc;
    }

    private String getCompletePath(URL url) {
        if (url.getQuery() == null) {
            return url.getPath();
        }
        return url.getPath() + "?" + url.getQuery();
    }

    private String getWSDLURL(Exchange exc) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getLocationProtocol());
        buf.append("://");
        buf.append(this.getLocationHost(exc));
        if (this.getLocationPort(exc) != 80) {
            buf.append(":");
            buf.append(this.getLocationPort(exc));
        }
        buf.append("/");
        buf.append(exc.getRequest().getUri());
        return buf.toString();
    }

    @MCAttribute
    public void setRegistryWSDLRegisterURL(String registryWSDLRegisterURL) {
        this.registryWSDLRegisterURL = registryWSDLRegisterURL;
    }

    public String getRegistryWSDLRegisterURL() {
        return this.registryWSDLRegisterURL;
    }

    @Override
    public String getShortDescription() {
        return "Rewrites SOAP endpoint addresses and XML Schema locations in WSDL and XSD documents.";
    }

    public void setRewriteEndpoint(boolean rewriteEndpoint) {
        this.rewriteEndpoint = rewriteEndpoint;
    }

    @Override
    @MCAttribute
    public void setProtocol(String protocol) {
        super.setProtocol(protocol);
    }

    @Override
    @MCAttribute
    public void setHost(String host) {
        super.setHost(host);
    }

    @Override
    @MCAttribute
    public void setPort(String port) {
        super.setPort(port);
    }
}

