/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.acl;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.FixedStreamReader;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.acl.AccessControl;
import com.predic8.membrane.core.interceptor.acl.Resource;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.membrane.core.util.HttpUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="accessControl")
public class AccessControlInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)AccessControlInterceptor.class.getName());
    private String file;
    private AccessControl accessControl;
    private boolean useXForwardedForAsClientAddr = false;

    public AccessControlInterceptor() {
        this.setDisplayName("access control");
        this.setFlow(Interceptor.Flow.Set.REQUEST_FLOW);
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        Resource resource;
        String remoteAddr = exc.getRemoteAddr();
        String remoteAddrIp = exc.getRemoteAddrIp();
        List<String> xff = HttpUtil.getForwardedForList(exc);
        if (this.useXForwardedForAsClientAddr && !xff.isEmpty()) {
            String xLast = xff.getLast();
            try {
                remoteAddrIp = InetAddress.getByName(xLast).getHostAddress();
            }
            catch (UnknownHostException e) {
                remoteAddr = xLast;
            }
        }
        try {
            resource = this.accessControl.getResourceFor(exc.getOriginalRequestUri());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            this.setResponseToAccessDenied(exc);
            return Outcome.ABORT;
        }
        if (!resource.checkAccess(remoteAddr, remoteAddrIp)) {
            this.setResponseToAccessDenied(exc);
            return Outcome.ABORT;
        }
        return Outcome.CONTINUE;
    }

    private void setResponseToAccessDenied(Exchange exc) {
        log.warn("Access Denied. Method: {} Uri: {}", (Object)exc.getRequest().getMethod(), (Object)exc.getOriginalRequestUri());
        ProblemDetails.security(false, this.getDisplayName()).title("Access Denied").statusCode(401).addSubSee("authorization-denied").buildAndSetResponse(exc);
    }

    @MCAttribute
    public void setUseXForwardedForAsClientAddr(boolean useXForwardedForAsClientAddr) {
        this.useXForwardedForAsClientAddr = useXForwardedForAsClientAddr;
    }

    public boolean isUseXForwardedForAsClientAddr() {
        return this.useXForwardedForAsClientAddr;
    }

    @MCAttribute
    @Required
    public void setFile(String file) {
        this.file = file;
    }

    public String getFile() {
        return this.file;
    }

    @Override
    public void init() {
        super.init();
        this.accessControl = this.parse(this.file, this.router);
    }

    public void setAccessControl(AccessControl ac) {
        this.accessControl = ac;
    }

    protected AccessControl parse(String fileName, Router router) {
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            FixedStreamReader reader = new FixedStreamReader(factory.createXMLStreamReader(router.getResolverMap().resolve(ResolverMap.combine(router.getBaseLocation(), fileName))));
            AccessControl res = (AccessControl)new AccessControl(router).parse(reader);
            res.init(router);
            return res;
        }
        catch (Exception e) {
            log.error("Error initializing accessControl.", (Throwable)e);
            System.err.println("Error initializing accessControl: terminating.");
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getShortDescription() {
        return "Authenticates incoming requests based on the file " + StringEscapeUtils.escapeHtml4((String)this.file) + " .";
    }
}

