/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.acl;

import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.interceptor.acl.AbstractClientAddress;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hostname
extends AbstractClientAddress {
    private static final Logger log = LoggerFactory.getLogger((String)Hostname.class.getName());
    public static final String ELEMENT_NAME = "hostname";
    private static final InetAddress localhostIp4 = Hostname.initV4();
    private static final InetAddress localhostIp6 = Hostname.initV6();
    private boolean reverseDNS;
    private volatile long lastWarningSlowReverseDNSUsed;

    private static InetAddress initV4() {
        try {
            return InetAddress.getByName("127.0.0.1");
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            log.error("Failed resolving localhost IPv4 127.0.0.1!");
            return null;
        }
    }

    private static InetAddress initV6() {
        try {
            return InetAddress.getByName("0:0:0:0:0:0:0:1");
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            log.error("Failed resolving localhost IPv6 0:0:0:0:0:0:0:1!");
            return null;
        }
    }

    public Hostname(Router router) {
        super(router);
    }

    @Override
    protected String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    public boolean matches(String hostname, String ip) {
        try {
            long now;
            InetAddress ia;
            if (this.schema.equals("^localhost$") && ((ia = InetAddress.getByName(ip)).equals(localhostIp4) || ia.equals(localhostIp6))) {
                log.debug("Address to be matched : {} is being matched to :{}", (Object)ia, (Object)this.schema);
                return true;
            }
            if (!this.reverseDNS && (now = System.currentTimeMillis()) - this.lastWarningSlowReverseDNSUsed > 600000L) {
                log.warn("transport/@reverseDNS=false is incompatible with ACL hostname filtering. (Please use ip filtering instead.) Slow reverse DNS lookup will be performed.");
                this.lastWarningSlowReverseDNSUsed = now;
            }
            String canonicalHostName = this.getCanonicalHostName(ip);
            log.debug("CanonicalHostname for {} / {} is {}", new Object[]{hostname, ip, canonicalHostName});
            return Pattern.compile(this.schema).matcher(canonicalHostName).matches();
        }
        catch (UnknownHostException e) {
            log.warn("Could not reverse lookup canonical hostname for {} {}.", (Object)hostname, (Object)ip);
            return false;
        }
    }

    @NotNull
    private String getCanonicalHostName(String ip) throws UnknownHostException {
        String canonicalHostName = this.router.getDnsCache().getCanonicalHostName(InetAddress.getByName(ip));
        if (canonicalHostName.startsWith("127.")) {
            return "localhost";
        }
        return canonicalHostName;
    }

    @Override
    public void init(Router router) {
        super.init(router);
        this.reverseDNS = router.getTransport().isReverseDNS();
    }
}

