/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.acl;

import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.config.AbstractXmlElement;
import com.predic8.membrane.core.config.GenericComplexElement;
import com.predic8.membrane.core.interceptor.acl.AbstractClientAddress;
import com.predic8.membrane.core.interceptor.acl.Any;
import com.predic8.membrane.core.interceptor.acl.Hostname;
import com.predic8.membrane.core.interceptor.acl.Ip;
import com.predic8.membrane.core.util.TextUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resource
extends AbstractXmlElement {
    private static final Logger log = LoggerFactory.getLogger((String)Resource.class.getName());
    public static final String ELEMENT_NAME = "resource";
    private final Router router;
    private final List<AbstractClientAddress> clientAddresses = new ArrayList<AbstractClientAddress>();
    protected Pattern uriPattern;

    public Resource(Router router) {
        this.router = router;
    }

    @Override
    protected String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    protected void parseChildren(XMLStreamReader token, String child) throws Exception {
        if ("ip".equals(child)) {
            this.clientAddresses.add((Ip)new Ip(this.router).parse(token));
        } else if ("hostname".equals(child)) {
            this.clientAddresses.add((Hostname)new Hostname(this.router).parse(token));
        } else if ("any".equals(child)) {
            this.clientAddresses.add((Any)new Any(this.router).parse(token));
        } else if ("clients".equals(child)) {
            new GenericComplexElement(this).parse(token);
        }
    }

    @Override
    protected void parseAttributes(XMLStreamReader token) throws XMLStreamException {
        this.uriPattern = Pattern.compile(TextUtil.globToRegExp(token.getAttributeValue(null, "uri")));
    }

    public boolean checkAccess(String hostname, String ip) {
        if (log.isDebugEnabled()) {
            log.debug("Hostname: " + hostname + (this.router.getTransport().isReverseDNS() ? "" : " (reverse DNS is disabled in configuration)"));
            log.debug("IP: " + ip);
            try {
                log.debug("Hostaddress (might require slow DNS lookup): " + this.router.getDnsCache().getHostName(InetAddress.getByName(ip)));
            }
            catch (UnknownHostException e) {
                log.debug("Failed to get hostname from address: " + e.getMessage());
            }
        }
        return this.clientAddresses.stream().anyMatch(address -> address.matches(hostname, ip));
    }

    public void addAddress(AbstractClientAddress addr) {
        this.clientAddresses.add(addr);
    }

    public boolean matches(String str) {
        return this.uriPattern.matcher(str).matches();
    }

    public void setUriPattern(Pattern uriPattern) {
        this.uriPattern = uriPattern;
    }

    public String getUriPattern() {
        return this.uriPattern.pattern();
    }

    public void init(Router router) {
        for (AbstractClientAddress ca : this.clientAddresses) {
            ca.init(router);
        }
    }
}

