/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.administration;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.administration.AdminRESTInterceptor;
import com.predic8.membrane.core.interceptor.administration.DynamicAdminPageInterceptor;
import com.predic8.membrane.core.interceptor.rewrite.RewriteInterceptor;
import com.predic8.membrane.core.interceptor.server.WebServerInterceptor;
import java.util.Arrays;
import java.util.List;

@MCElement(name="adminConsole")
public class AdminConsoleInterceptor
extends AbstractInterceptor {
    private final RewriteInterceptor rewriteInterceptor = new RewriteInterceptor();
    private final DynamicAdminPageInterceptor dapi = new DynamicAdminPageInterceptor();
    private final AdminRESTInterceptor rai = new AdminRESTInterceptor();
    private final WebServerInterceptor wsi = new WebServerInterceptor();
    private final List<Interceptor> interceptors = Arrays.asList(this.rewriteInterceptor, this.rai, this.dapi, this.wsi);
    private boolean useXForwardedForAsClientAddr = false;

    public AdminConsoleInterceptor() {
        this.name = "administration";
        this.rewriteInterceptor.getMappings().add(new RewriteInterceptor.Mapping("^/?$", "/admin", "redirect"));
        this.wsi.setDocBase("classpath:/com/predic8/membrane/core/interceptor/administration/docBase");
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        Outcome result = this.getFlowController().invokeRequestHandlers(exc, this.interceptors);
        if (exc.getRequest().getHeader().getFirstValue("X-Requested-With") != null && exc.getResponse() != null) {
            exc.getResponse().getHeader().add("Expires", "-1");
        }
        return result;
    }

    @Override
    public void init() {
        super.init();
        this.rewriteInterceptor.init(this.router);
        this.rai.setUseXForwardedForAsClientAddr(this.useXForwardedForAsClientAddr);
        this.rai.init(this.router);
        this.dapi.setUseXForwardedForAsClientAddr(this.useXForwardedForAsClientAddr);
        this.dapi.init(this.router);
        this.wsi.init(this.router);
    }

    public boolean isReadOnly() {
        return this.dapi.isReadOnly();
    }

    @MCAttribute
    public void setReadOnly(boolean readOnly) {
        this.rai.setReadOnly(readOnly);
        this.dapi.setReadOnly(readOnly);
    }

    public boolean isUseXForwardedForAsClientAddr() {
        return this.useXForwardedForAsClientAddr;
    }

    @MCAttribute
    public void setUseXForwardedForAsClientAddr(boolean useXForwardedForAsClientAddr) {
        this.useXForwardedForAsClientAddr = useXForwardedForAsClientAddr;
    }

    @Override
    public String getShortDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Displays the ");
        if (this.dapi.isReadOnly()) {
            sb.append("read-only ");
        }
        sb.append("admin console.");
        return sb.toString();
    }
}

