/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.administration;

import com.fasterxml.jackson.core.JsonGenerator;
import com.predic8.membrane.core.exchange.AbstractExchange;
import com.predic8.membrane.core.exchange.ExchangeState;
import com.predic8.membrane.core.exchange.ExchangesUtil;
import com.predic8.membrane.core.exchangestore.ClientStatistics;
import com.predic8.membrane.core.exchangestore.ExchangeQueryResult;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.HeaderField;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.administration.Mapping;
import com.predic8.membrane.core.interceptor.administration.RuleUtil;
import com.predic8.membrane.core.interceptor.rest.QueryParameter;
import com.predic8.membrane.core.interceptor.rest.RESTInterceptor;
import com.predic8.membrane.core.interceptor.statistics.util.JDBCUtil;
import com.predic8.membrane.core.proxies.AbstractServiceProxy;
import com.predic8.membrane.core.proxies.Proxy;
import com.predic8.membrane.core.util.ComparatorFactory;
import com.predic8.membrane.core.util.TextUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminRESTInterceptor
extends RESTInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)AdminRESTInterceptor.class.getName());
    private boolean useXForwardedForAsClientAddr;

    @Mapping(value="/admin/rest/clients(/?\\?.*)?")
    public Response getClients(QueryParameter params, String relativeRootPath) throws Exception {
        List<? extends ClientStatistics> clients = this.getRouter().getExchangeStore().getClientStatistics();
        clients.sort(ComparatorFactory.getClientStatisticsComparator(params.getString("sort", "name"), params.getString("order", "asc")));
        int offset = params.getInt("offset", 0);
        return this.json(gen -> {
            gen.writeStartObject();
            gen.writeArrayFieldStart("clients");
            for (ClientStatistics s : clients.subList(offset, Math.min(offset + AdminRESTInterceptor.getMax(params, clients), clients.size()))) {
                gen.writeStartObject();
                gen.writeStringField("name", s.getClient());
                gen.writeNumberField("count", s.getCount());
                gen.writeNumberField("min", s.getMinDuration());
                gen.writeNumberField("max", s.getMaxDuration());
                gen.writeNumberField("avg", s.getAvgDuration());
                gen.writeEndObject();
            }
            gen.writeEndArray();
            gen.writeNumberField("total", clients.size());
            gen.writeEndObject();
        });
    }

    private static int getMax(QueryParameter params, List<? extends ClientStatistics> clients) {
        return params.getInt("max", clients.size());
    }

    @Mapping(value="/admin/rest/proxies(/?\\?.*)?")
    public Response getProxies(QueryParameter params, String relativeRootPath) throws Exception {
        List<AbstractServiceProxy> proxies = this.getServiceProxies();
        if ("order".equals(params.getString("sort"))) {
            if (params.getString("order", "asc").equals("desc")) {
                Collections.reverse(proxies);
            }
        } else {
            proxies.sort(ComparatorFactory.getAbstractServiceProxyComparator(params.getString("sort", "name"), params.getString("order", "asc")));
        }
        int offset = params.getInt("offset", 0);
        int max = params.getInt("max", proxies.size());
        List<AbstractServiceProxy> paginated = proxies.subList(offset, Math.min(offset + max, proxies.size()));
        return this.json(gen -> {
            gen.writeStartObject();
            gen.writeArrayFieldStart("proxies");
            int i = offset;
            if (params.getString("order", "asc").equals("desc")) {
                i = proxies.size() - i + 1;
            }
            for (AbstractServiceProxy p : paginated) {
                gen.writeStartObject();
                gen.writeNumberField("order", i += params.getString("order", "asc").equals("desc") ? -1 : 1);
                gen.writeStringField("name", p.toString());
                gen.writeBooleanField("active", p.isActive());
                if (!p.isActive()) {
                    gen.writeStringField("error", p.getErrorState());
                }
                gen.writeNumberField("listenPort", p.getKey().getPort());
                gen.writeStringField("virtualHost", p.getKey().getHost());
                gen.writeStringField("method", p.getKey().getMethod());
                gen.writeStringField("path", p.getKey().getPath());
                gen.writeStringField("targetHost", p.getTargetHost());
                gen.writeNumberField("targetPort", p.getTargetPort());
                gen.writeNumberField("count", p.getStatisticCollector().getCount());
                gen.writeObjectFieldStart("actions");
                if (!this.isReadOnly()) {
                    gen.writeStringField("delete", "/admin/service-proxy/delete?name=" + URLEncoder.encode(RuleUtil.getRuleIdentifier(p), StandardCharsets.UTF_8));
                }
                if (!p.isActive()) {
                    gen.writeStringField("start", "/admin/service-proxy/start?name=" + URLEncoder.encode(RuleUtil.getRuleIdentifier(p), StandardCharsets.UTF_8));
                }
                gen.writeEndObject();
                gen.writeEndObject();
            }
            gen.writeEndArray();
            gen.writeNumberField("total", proxies.size());
            gen.writeEndObject();
        });
    }

    @Mapping(value="/admin/rest/exchanges/(-?\\d+)/(response|request)/raw")
    public Response getRaw(QueryParameter params, String relativeRootPath) {
        Message msg;
        AbstractExchange exc = this.router.getExchangeStore().getExchangeById(params.getGroupLong(1));
        if (exc == null) {
            return Response.notFound().build();
        }
        Message message = msg = params.getGroup(2).equals("response") ? exc.getResponse() : exc.getRequest();
        if (msg == null) {
            return Response.noContent().build();
        }
        return Response.ok().contentType("text/plain;charset=UTF-8").body(msg.toString()).build();
    }

    @Mapping(value="/admin/web/exchanges/(-?\\d+)/(response|request)/body")
    public Response getBeautifiedBody(QueryParameter params, String relativeRootPath) throws Exception {
        Message msg;
        AbstractExchange exc = this.router.getExchangeStore().getExchangeById(params.getGroupLong(1));
        if (exc == null) {
            return Response.notFound().build();
        }
        Message message = msg = params.getGroup(2).equals("response") ? exc.getResponse() : exc.getRequest();
        if (msg == null || msg.isBodyEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok().contentType("text/html;charset=UTF-8").body(TextUtil.formatXML(new InputStreamReader(msg.getBodyAsStreamDecoded(), msg.getCharset()), true)).build();
    }

    @Mapping(value="/admin/rest/exchanges/(-?\\d+)/(response|request)/body")
    public Response getRequestBody(QueryParameter params, String relativeRootPath) throws Exception {
        String ct;
        AbstractExchange exc = this.router.getExchangeStore().getExchangeById(params.getGroupLong(1));
        if (exc == null) {
            return Response.notFound().build();
        }
        Message msg = params.getGroup(2).equals("response") ? exc.getResponse() : exc.getRequest();
        String string = ct = params.getGroup(2).equals("response") ? exc.getResponseContentType() : exc.getRequestContentType();
        if (msg == null || msg.isBodyEmpty()) {
            return Response.noContent().build();
        }
        Response.ResponseBuilder rb = Response.ok().contentType(ct).body(msg.getBodyAsStream(), false);
        String contentEncoding = msg.getHeader().getContentEncoding();
        if (contentEncoding != null) {
            rb.header("Content-Encoding", contentEncoding);
        }
        return rb.build();
    }

    @Mapping(value="/admin/rest/exchanges/(-?\\d+)/(response|request)/header")
    public Response getRequestHeader(QueryParameter params, String relativeRootPath) throws Exception {
        Message msg;
        AbstractExchange exc = this.router.getExchangeStore().getExchangeById(params.getGroupLong(1));
        if (exc == null) {
            return Response.notFound().build();
        }
        Message message = msg = params.getGroup(2).equals("response") ? exc.getResponse() : exc.getRequest();
        if (msg == null) {
            return Response.noContent().build();
        }
        return this.json(gen -> {
            gen.writeStartObject();
            gen.writeArrayFieldStart("headers");
            for (HeaderField hf : msg.getHeader().getAllHeaderFields()) {
                gen.writeStartObject();
                gen.writeStringField("name", hf.getHeaderName().toString());
                gen.writeStringField("value", hf.getValue());
                gen.writeEndObject();
            }
            gen.writeEndArray();
            gen.writeEndObject();
        });
    }

    @Mapping(value="/admin/rest/exchanges/(-?\\d+)")
    public Response getExchange(QueryParameter params, String relativeRootPath) throws Exception {
        AbstractExchange exc = this.router.getExchangeStore().getExchangeById(params.getGroupLong(1));
        if (exc == null) {
            return Response.notFound().build();
        }
        return this.json(gen -> this.writeExchange(exc, gen));
    }

    @Mapping(value="/admin/rest/exchanges(/?\\?.*)?")
    public Response getExchanges(QueryParameter params, String relativeRootPath) throws Exception {
        if (params.getString("waitForModification") != null) {
            this.getRouter().getExchangeStore().waitForModification(params.getLong("waitForModification"));
        }
        ExchangeQueryResult res = this.getRouter().getExchangeStore().getFilteredSortedPaged(params, this.useXForwardedForAsClientAddr);
        return this.json(gen -> {
            gen.writeStartObject();
            gen.writeArrayFieldStart("exchanges");
            for (AbstractExchange e : res.getExchanges()) {
                this.writeExchange(e, gen);
            }
            gen.writeEndArray();
            gen.writeNumberField("total", res.getCount());
            gen.writeNumberField("lastModified", res.getLastModified());
            gen.writeEndObject();
        });
    }

    private void writeExchange(AbstractExchange exc, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeNumberField("id", exc.getId());
        if (exc.getResponse() != null) {
            gen.writeNumberField("statusCode", exc.getResponse().getStatusCode());
            if (exc.getResponseContentLength() != -1L) {
                gen.writeNumberField("respContentLength", exc.getResponseContentLength());
            } else {
                gen.writeNullField("respContentLength");
            }
        } else {
            gen.writeNullField("statusCode");
            gen.writeNullField("respContentLength");
        }
        gen.writeStringField("time", ExchangesUtil.getTime(exc));
        gen.writeStringField("proxy", exc.getProxy().toString());
        gen.writeNumberField("listenPort", exc.getProxy().getKey().getPort());
        if (exc.getRequest() != null) {
            gen.writeStringField("method", exc.getRequest().getMethod());
            gen.writeStringField("path", exc.getRequest().getUri());
            gen.writeStringField("reqContentType", exc.getRequestContentType());
            gen.writeStringField("protocol", exc.getProperty("h2_server") != null ? "2" : exc.getRequest().getVersion());
        } else {
            gen.writeNullField("method");
            gen.writeNullField("path");
            gen.writeNullField("reqContentType");
            if (exc.getProperty("h2_server") != null) {
                gen.writeStringField("protocol", "2");
            } else {
                gen.writeNullField("protocol");
            }
        }
        gen.writeStringField("client", AdminRESTInterceptor.getClientAddr(this.useXForwardedForAsClientAddr, exc));
        gen.writeStringField("server", exc.getServer());
        gen.writeNumberField("serverPort", this.getServerPort(exc));
        if (exc.getRequest() != null && exc.getRequestContentLength() != -1L) {
            gen.writeNumberField("reqContentLength", exc.getRequestContentLength());
        } else {
            gen.writeNullField("reqContentLength");
        }
        gen.writeStringField("respContentType", exc.getResponseContentType());
        if (exc.getStatus() == ExchangeState.RECEIVED || exc.getStatus() == ExchangeState.COMPLETED) {
            if (exc.getResponse() != null && exc.getResponseContentLength() != -1L) {
                gen.writeNumberField("respContentLength", exc.getResponseContentLength());
            } else {
                gen.writeNullField("respContentLength");
            }
        } else {
            gen.writeStringField("respContentLength", "Not finished");
        }
        gen.writeNumberField("duration", exc.getTimeResReceived() - exc.getTimeReqSent());
        gen.writeStringField("msgFilePath", JDBCUtil.getFilePath(exc));
        gen.writeEndObject();
    }

    public static String getClientAddr(boolean useXForwardedForAsClientAddr, AbstractExchange exc) {
        String value;
        Header header;
        Request request;
        if (useXForwardedForAsClientAddr && (request = exc.getRequest()) != null && (header = request.getHeader()) != null && (value = header.getFirstValue("X-Forwarded-For")) != null) {
            return value;
        }
        return exc.getRemoteAddr();
    }

    private int getServerPort(AbstractExchange exc) {
        return exc.getProxy() instanceof AbstractServiceProxy ? ((AbstractServiceProxy)exc.getProxy()).getTargetPort() : -1;
    }

    private List<AbstractServiceProxy> getServiceProxies() {
        LinkedList<AbstractServiceProxy> rules = new LinkedList<AbstractServiceProxy>();
        for (Proxy r : this.router.getRuleManager().getRules()) {
            if (!(r instanceof AbstractServiceProxy)) continue;
            rules.add((AbstractServiceProxy)r);
        }
        return rules;
    }

    public boolean isUseXForwardedForAsClientAddr() {
        return this.useXForwardedForAsClientAddr;
    }

    public void setUseXForwardedForAsClientAddr(boolean useXForwardedForAsClientAddr) {
        this.useXForwardedForAsClientAddr = useXForwardedForAsClientAddr;
    }
}

