/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.administration;

import com.predic8.membrane.core.exchange.AbstractExchange;
import com.predic8.membrane.core.exchangestore.ExchangeCollector;
import com.predic8.membrane.core.interceptor.administration.AdminRESTInterceptor;
import java.util.HashSet;
import java.util.Set;

public class PropertyValueCollector
implements ExchangeCollector {
    Set<Integer> statusCodes = new HashSet<Integer>();
    Set<String> proxies = new HashSet<String>();
    Set<String> reqContentTypes = new HashSet<String>();
    Set<String> respContentTypes = new HashSet<String>();
    Set<String> methods = new HashSet<String>();
    Set<String> clients = new HashSet<String>();
    Set<String> servers = new HashSet<String>();
    boolean useXForwardedForAsClientAddr;

    public void setUseXForwardedForAsClientAddr(boolean useXForwardedForAsClientAddr) {
        this.useXForwardedForAsClientAddr = useXForwardedForAsClientAddr;
    }

    @Override
    public void collect(AbstractExchange exc) {
        if (exc.getResponse() != null) {
            this.statusCodes.add(exc.getResponse().getStatusCode());
        }
        this.proxies.add(exc.getProxy().toString());
        this.reqContentTypes.add(exc.getRequestContentType());
        this.respContentTypes.add(exc.getResponseContentType());
        this.methods.add(exc.getRequest().getMethod());
        this.clients.add(AdminRESTInterceptor.getClientAddr(this.useXForwardedForAsClientAddr, exc));
        this.servers.add(exc.getServer());
    }

    public Set<Integer> getStatusCodes() {
        return this.statusCodes;
    }

    public Set<String> getProxies() {
        return this.proxies;
    }

    public Set<String> getReqContentTypes() {
        return this.reqContentTypes;
    }

    public Set<String> getRespContentTypes() {
        return this.respContentTypes;
    }

    public Set<String> getMethods() {
        return this.methods;
    }

    public Set<String> getClients() {
        return this.clients;
    }

    public Set<String> getServers() {
        return this.servers;
    }
}

