/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.antivirus;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import fi.solita.clamav.ClamAVClient;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="clamav")
public class ClamAntiVirusInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ClamAntiVirusInterceptor.class);
    private String host = "localhost";
    private String port = "3310";
    ClamAVClient client;

    public ClamAntiVirusInterceptor() {
        this.name = "clam av";
    }

    @Override
    public String getShortDescription() {
        return "Scans responses for malicious content.";
    }

    @Override
    public void init() {
        super.init();
        this.client = new ClamAVClient(this.getHost(), Integer.parseInt(this.getPort()));
        log.info("Using clamav daemon on [{}:{}]", (Object)this.getHost(), (Object)this.getPort());
    }

    @Override
    public Outcome handleResponse(Exchange exc) {
        try {
            if (this.isNotMalicious(this.getHeaders(exc)) && this.isNotMalicious(this.getBody(exc))) {
                return Outcome.CONTINUE;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.gatewayTimeout(exc);
    }

    private String getBody(Exchange exc) {
        return exc.getRequest().getBodyAsStringDecoded();
    }

    private Outcome gatewayTimeout(Exchange exc) {
        log.error("Could not reach clamav daemon on {}:{}", (Object)this.host, (Object)this.port);
        ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).title("Virus scanner error!").detail("Could not execute virus scan.").internal("message", "Could not reach clamav daemon.").internal("scanner-host", this.host).internal("scanner-port", this.port).buildAndSetResponse(exc);
        return Outcome.RETURN;
    }

    public boolean isNotMalicious(String str) throws IOException {
        try (InputStream input = this.toInputStream(str);){
            boolean bl = ClamAVClient.isCleanReply((byte[])this.client.scan(input));
            return bl;
        }
    }

    private InputStream toInputStream(String str) {
        return IOUtils.toInputStream((String)str);
    }

    private String getHeaders(Exchange exc) {
        return exc.getRequest().getHeader().toString();
    }

    public String getHost() {
        return this.host;
    }

    @MCAttribute
    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    @MCAttribute
    public void setPort(String port) {
        this.port = port;
    }
}

