/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.apikey;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.apikey.extractors.ApiKeyExtractor;
import com.predic8.membrane.core.interceptor.apikey.extractors.LocationNameValue;
import com.predic8.membrane.core.interceptor.apikey.stores.ApiKeyStore;
import com.predic8.membrane.core.interceptor.apikey.stores.UnauthorizedApiKeyException;
import com.predic8.membrane.core.security.ApiKeySecurityScheme;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="apiKey")
public class ApiKeysInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)ApiKeysInterceptor.class.getName());
    public static final String SCOPES = "membrane-scopes";
    public static final String TYPE_4XX = "authorization-denied";
    public static final String TITLE_4XX = "Access Denied";
    private final List<ApiKeyStore> stores = new ArrayList<ApiKeyStore>();
    private final List<ApiKeyExtractor> extractors = new ArrayList<ApiKeyExtractor>();
    private boolean required = true;

    public ApiKeysInterceptor() {
        this.name = "api key";
    }

    @Override
    public String getShortDescription() {
        return this.required ? "Secures access with api keys and RBAC with scopes. " : "Warning: Required is set to <code>false</code>, scopes will be extracted but any api key, even missing ones, will be accepted.";
    }

    @Override
    public String getLongDescription() {
        return this.getShortDescription() + "<br/>" + this.extractors.stream().map(extractor -> extractor.getDescription() + "<br/>").collect(Collectors.joining());
    }

    @Override
    public void init() {
        super.init();
        this.stores.addAll(this.router.getBeanFactory().getBeansOfType(ApiKeyStore.class).values());
        this.stores.forEach(s -> s.init(this.router));
        this.extractors.forEach(e -> e.init(this.router));
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        Optional<LocationNameValue> key = this.getKey(exc);
        if (this.required && key.isEmpty()) {
            log.warn("Tried access apiKey protected resource without key. Uri: {}", (Object)exc.getRequestURI());
            ProblemDetails.security(false, this.getDisplayName()).title(TITLE_4XX).statusCode(401).addSubType(TYPE_4XX).detail("Tried to access API key protected resource without key.").buildAndSetResponse(exc);
            return Outcome.RETURN;
        }
        if (key.isPresent()) {
            try {
                LocationNameValue k = key.get();
                new ApiKeySecurityScheme(k.location(), k.name()).scopes(this.getScopes(k.key())).add(exc);
            }
            catch (UnauthorizedApiKeyException e) {
                if (!this.required) {
                    return Outcome.CONTINUE;
                }
                log.warn("The provided API {} key is invalid.", (Object)key.get());
                ProblemDetails.security(false, this.getDisplayName()).title(TITLE_4XX).statusCode(403).addSubType(TYPE_4XX).detail("The provided API key is invalid.").buildAndSetResponse(exc);
                return Outcome.RETURN;
            }
        }
        return Outcome.CONTINUE;
    }

    public Set<String> getScopes(String key) throws UnauthorizedApiKeyException {
        LinkedHashSet combinedScopes = new LinkedHashSet();
        boolean keyFound = false;
        for (ApiKeyStore store : this.stores) {
            try {
                store.getScopes(key).ifPresent(combinedScopes::addAll);
                keyFound = true;
            }
            catch (Exception exception) {}
        }
        if (!keyFound) {
            throw new UnauthorizedApiKeyException();
        }
        return new HashSet<String>(combinedScopes);
    }

    public Optional<LocationNameValue> getKey(Exchange exc) {
        return this.extractors.stream().flatMap(ext -> Stream.ofNullable(ext.extract(exc).orElse(null))).findFirst();
    }

    @MCAttribute
    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isRequired() {
        return this.required;
    }

    @MCChildElement(allowForeign=true)
    public void setStores(List<ApiKeyStore> stores) {
        this.stores.addAll(stores);
    }

    public List<ApiKeyStore> getStores() {
        return this.stores;
    }

    @MCChildElement(allowForeign=true, order=1)
    public void setExtractors(List<ApiKeyExtractor> extractors) {
        this.extractors.addAll(extractors);
    }

    public List<ApiKeyExtractor> getExtractors() {
        return this.extractors;
    }
}

