/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.apikey.extractors;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.apikey.extractors.ApiKeyExtractor;
import com.predic8.membrane.core.interceptor.apikey.extractors.LocationNameValue;
import com.predic8.membrane.core.interceptor.lang.Polyglot;
import com.predic8.membrane.core.lang.ExchangeExpression;
import com.predic8.membrane.core.security.ApiKeySecurityScheme;
import com.predic8.membrane.core.util.ConfigurationException;
import java.util.Optional;

@MCElement(name="expressionExtractor", topLevel=false)
public class ApiKeyExpressionExtractor
implements ApiKeyExtractor,
Polyglot {
    private String expression = "";
    private ExchangeExpression.Language language = ExchangeExpression.Language.SPEL;
    private ExchangeExpression exchangeExpression;

    @Override
    public void init(Router router) {
        this.exchangeExpression = ExchangeExpression.newInstance(router, this.language, this.expression);
    }

    @Override
    public Optional<LocationNameValue> extract(Exchange exc) {
        return Optional.of(new LocationNameValue(ApiKeySecurityScheme.In.EXPRESSION, this.expression, this.exchangeExpression.evaluate(exc, Interceptor.Flow.REQUEST, String.class)));
    }

    @Override
    public String getDescription() {
        return "Expression: " + this.expression + ". ";
    }

    @Override
    @MCAttribute
    public void setLanguage(String language) {
        try {
            this.language = ExchangeExpression.Language.valueOf(language);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException("Wrong Language\n\nLanguage %s is not supported by this API key extractor. Use one of {}\n".formatted(new Object[]{language, ExchangeExpression.Language.values()}));
        }
    }

    public String getExpression() {
        return this.expression;
    }

    @MCAttribute
    public void setExpression(String expression) {
        this.expression = expression;
    }
}

