/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.apikey.extractors;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.HeaderName;
import com.predic8.membrane.core.interceptor.apikey.extractors.ApiKeyExtractor;
import com.predic8.membrane.core.interceptor.apikey.extractors.LocationNameValue;
import com.predic8.membrane.core.security.ApiKeySecurityScheme;
import java.util.Optional;

@MCElement(name="headerExtractor", topLevel=false)
public class ApiKeyHeaderExtractor
implements ApiKeyExtractor {
    private HeaderName headerName = new HeaderName("X-Api-Key");

    @Override
    public Optional<LocationNameValue> extract(Exchange exc) {
        Header header = exc.getRequest().getHeader();
        if (header.contains(this.headerName)) {
            return Optional.of(new LocationNameValue(ApiKeySecurityScheme.In.HEADER, this.headerName.getName(), header.getFirstValue(this.headerName)));
        }
        return Optional.empty();
    }

    @MCAttribute(attributeName="name")
    public void setHeaderName(String headerName) {
        this.headerName = new HeaderName(headerName);
    }

    public String getHeaderName() {
        return this.headerName.getName();
    }

    @Override
    public String getDescription() {
        return "Header Name: " + String.valueOf(this.headerName) + ". ";
    }
}

