/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.apikey.extractors;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.apikey.extractors.ApiKeyExtractor;
import com.predic8.membrane.core.interceptor.apikey.extractors.LocationNameValue;
import com.predic8.membrane.core.security.ApiKeySecurityScheme;
import com.predic8.membrane.core.util.URIFactory;
import com.predic8.membrane.core.util.URLParamUtil;
import java.util.Optional;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="queryParamExtractor", topLevel=false)
public class ApiKeyQueryParamExtractor
implements ApiKeyExtractor {
    private static final Logger log = LoggerFactory.getLogger(ApiKeyQueryParamExtractor.class);
    private String paramName = "api-key";

    @Override
    public Optional<LocationNameValue> extract(Exchange exc) {
        TreeMap<String, String> queryParams;
        try {
            queryParams = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            queryParams.putAll(URLParamUtil.getParams(new URIFactory(), exc, URLParamUtil.DuplicateKeyOrInvalidFormStrategy.ERROR));
        }
        catch (Exception e) {
            log.info("Error extracting query parameters. From " + exc.getRequest().getUri());
            return Optional.empty();
        }
        if (queryParams.containsKey(this.paramName.toLowerCase())) {
            return Optional.of(new LocationNameValue(ApiKeySecurityScheme.In.QUERY, this.paramName, (String)queryParams.get(this.paramName.toLowerCase())));
        }
        return Optional.empty();
    }

    @MCAttribute(attributeName="name")
    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public String getParamName() {
        return this.paramName;
    }

    @Override
    public String getDescription() {
        return "Query Param name: " + this.paramName + ". ";
    }
}

