/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.apikey.stores;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.interceptor.apikey.ApiKeyUtils;
import com.predic8.membrane.core.interceptor.apikey.stores.ApiKeyStore;
import com.predic8.membrane.core.interceptor.apikey.stores.UnauthorizedApiKeyException;
import com.predic8.membrane.core.util.ConfigurationException;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@MCElement(name="apiKeyFileStore")
public class ApiKeyFileStore
implements ApiKeyStore {
    private String location;
    private Map<String, Optional<List<String>>> scopes;

    @Override
    public void init(Router router) {
        try {
            this.scopes = ApiKeyFileStore.readKeyData(ApiKeyUtils.readFile(this.location, router.getResolverMap(), router.getBaseLocation()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Optional<List<String>>> readKeyData(Stream<String> lines) throws IOException {
        Map<String, Optional<List<String>>> collect;
        try {
            collect = lines.map(ApiKeyFileStore::extractKeyBeforeHash).filter(line -> !line.isEmpty()).map(ApiKeyFileStore::parseLine).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to read API key file: " + String.valueOf(e));
        }
        return collect;
    }

    static String extractKeyBeforeHash(String line) {
        return line.split("#", 2)[0];
    }

    static AbstractMap.SimpleEntry<String, Optional<List<String>>> parseLine(String line) {
        List<String> parts = ApiKeyFileStore.getParts(line);
        return new AbstractMap.SimpleEntry<String, Optional<List<String>>>(parts.get(0), ApiKeyFileStore.getValue(parts));
    }

    private static List<String> getParts(String line) {
        return Arrays.stream(line.split(":", 2)).map(String::trim).toList();
    }

    private static Optional<List<String>> getValue(List<String> parts) {
        return parts.size() > 1 && !parts.get(1).isEmpty() ? Optional.of(ApiKeyFileStore.parseValues(parts.get(1))) : Optional.empty();
    }

    static List<String> parseValues(String valuesPart) {
        return Arrays.stream(valuesPart.split(",")).map(String::trim).toList();
    }

    @Override
    public Optional<List<String>> getScopes(String key) throws UnauthorizedApiKeyException {
        if (this.scopes.containsKey(key)) {
            return this.scopes.get(key);
        }
        throw new UnauthorizedApiKeyException();
    }

    @MCAttribute
    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }
}

