/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.apikey.stores;

import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.interceptor.apikey.stores.ApiKeyStore;
import com.predic8.membrane.core.interceptor.apikey.stores.KeyTable;
import com.predic8.membrane.core.interceptor.apikey.stores.ScopeTable;
import com.predic8.membrane.core.interceptor.apikey.stores.UnauthorizedApiKeyException;
import com.predic8.membrane.core.util.ConfigurationException;
import com.predic8.membrane.core.util.jdbc.AbstractJdbcSupport;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@MCElement(name="databaseApiKeyStore")
public class JDBCApiKeyStore
extends AbstractJdbcSupport
implements ApiKeyStore {
    private KeyTable keyTable;
    private ScopeTable scopeTable;

    @Override
    public void init(Router router) {
        super.init(router);
        this.createTablesIfNotExist();
    }

    @Override
    public Optional<List<String>> getScopes(String apiKey) throws UnauthorizedApiKeyException {
        try {
            this.checkApiKey(apiKey);
            return this.fetchScopes(apiKey);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while retrieving scopes for API key: " + apiKey, e);
        }
    }

    private void checkApiKey(String apiKey) throws Exception {
        try (PreparedStatement stmt = this.getDatasource().getConnection().prepareStatement("SELECT * FROM %s WHERE apikey = ?".formatted(this.keyTable.getName()));){
            stmt.setString(1, apiKey);
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) {
                    throw new UnauthorizedApiKeyException();
                }
            }
        }
    }

    @NotNull
    private Optional<List<String>> fetchScopes(String apiKey) throws SQLException {
        try (PreparedStatement stmt = this.getDatasource().getConnection().prepareStatement("SELECT * FROM %s a,%s s WHERE a.apikey=s.apikey AND a.apikey = ?".formatted(this.keyTable.getName(), this.scopeTable.getName()));){
            Optional<List<String>> optional;
            block13: {
                stmt.setString(1, apiKey);
                ResultSet rs = stmt.executeQuery();
                try {
                    ArrayList<String> scopes = new ArrayList<String>();
                    while (rs.next()) {
                        scopes.add(rs.getString("scope"));
                    }
                    optional = Optional.of(scopes);
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return optional;
        }
    }

    private void createTablesIfNotExist() {
        try (Connection connection = this.getDatasource().getConnection();){
            if (this.tableExists(connection, this.keyTable.getName())) {
                connection.createStatement().executeUpdate(String.format("CREATE TABLE %s (\n    apikey VARCHAR(255) NOT NULL PRIMARY KEY\n)\n", this.keyTable.getName()));
            }
            if (this.tableExists(connection, this.scopeTable.getName())) {
                connection.createStatement().executeUpdate(String.format("CREATE TABLE %s (\n    apikey VARCHAR(255) NOT NULL REFERENCES %s (apikey),\n    scope VARCHAR(255) NOT NULL\n)\n", this.scopeTable.getName(), this.keyTable.getName()));
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to create tables for API Keys %s and %s: ".formatted(this.keyTable.getName(), this.scopeTable.getName()), e);
        }
    }

    private boolean tableExists(Connection connection, String tableName) throws SQLException {
        return !connection.getMetaData().getTables(null, null, tableName.toUpperCase(), null).next();
    }

    @MCChildElement(order=0)
    public void setKeyTable(KeyTable keyTable) {
        this.keyTable = keyTable;
    }

    @MCChildElement(order=1)
    public void setScopeTable(ScopeTable scopeTable) {
        this.scopeTable = scopeTable;
    }

    public KeyTable getKeyTable() {
        return this.keyTable;
    }

    public ScopeTable getScopeTable() {
        return this.scopeTable;
    }
}

