/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.apikey.stores;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.interceptor.apikey.stores.ApiKeyStore;
import com.predic8.membrane.core.interceptor.apikey.stores.UnauthorizedApiKeyException;
import com.predic8.membrane.core.util.ConfigurationException;
import java.util.List;
import java.util.Optional;
import org.bson.Document;

@MCElement(name="mongoDBApiKeyStore")
public class MongoDBApiKeyStore
implements ApiKeyStore {
    private String connection;
    private String database;
    private String collection;
    private MongoClient mongoClient;
    private MongoDatabase mongoDatabase;

    @Override
    public void init(Router router) {
        try {
            this.mongoClient = MongoClients.create((String)this.connection);
            this.mongoDatabase = this.mongoClient.getDatabase(this.database);
        }
        catch (Exception e) {
            throw new ConfigurationException("        Failed to initialize MongoDB connection.\n        Please check the connection string: %s\n".formatted(this.connection), e);
        }
    }

    @Override
    public Optional<List<String>> getScopes(String apiKey) throws UnauthorizedApiKeyException {
        Document apiKeyDoc = (Document)this.mongoDatabase.getCollection(this.collection).find(Filters.eq((String)"_id", (Object)apiKey)).first();
        if (apiKeyDoc == null) {
            throw new UnauthorizedApiKeyException();
        }
        return Optional.ofNullable(apiKeyDoc.getList((Object)"scopes", String.class));
    }

    @MCAttribute
    public void setConnection(String connection) {
        this.connection = connection;
    }

    @MCAttribute
    public void setDatabase(String database) {
        this.database = database;
    }

    @MCAttribute
    public void setCollection(String collection) {
        this.collection = collection;
    }

    public String getConnection() {
        return this.connection;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getCollection() {
        return this.collection;
    }
}

