/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.apikey.stores.inConfig;

import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.interceptor.apikey.stores.ApiKeyStore;
import com.predic8.membrane.core.interceptor.apikey.stores.UnauthorizedApiKeyException;
import com.predic8.membrane.core.interceptor.apikey.stores.inConfig.Key;
import com.predic8.membrane.core.interceptor.apikey.stores.inConfig.Scope;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@MCElement(name="keys", topLevel=false)
public class SimpleKeyStore
implements ApiKeyStore {
    private final List<Key> keys = new ArrayList<Key>();

    @MCChildElement(allowForeign=true)
    public void setKeys(List<Key> keys) {
        this.keys.addAll(keys);
    }

    public List<Key> getKeys() {
        return this.keys;
    }

    @Override
    public void init(Router router) {
    }

    @Override
    public Optional<List<String>> getScopes(String apiKey) throws UnauthorizedApiKeyException {
        Optional<Key> key = this.keys.stream().filter(k -> k.getValue().equals(apiKey)).findFirst();
        if (key.isPresent()) {
            List scopeValues = key.get().getScopes().stream().map(Scope::getValue).collect(Collectors.toList());
            return Optional.ofNullable(scopeValues.isEmpty() ? null : scopeValues);
        }
        throw new UnauthorizedApiKeyException();
    }
}

