/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.authentication;

import com.google.common.collect.ImmutableMap;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.authentication.session.StaticUserDataProvider;
import com.predic8.membrane.core.interceptor.authentication.session.UserDataProvider;
import com.predic8.membrane.core.security.HttpSecurityScheme;
import com.predic8.membrane.core.util.HttpUtil;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.text.StringEscapeUtils;

@MCElement(name="basicAuthentication")
public class BasicAuthenticationInterceptor
extends AbstractInterceptor {
    private UserDataProvider userDataProvider = new StaticUserDataProvider();

    public BasicAuthenticationInterceptor() {
        this.name = "basic authenticator";
        this.setFlow(Interceptor.Flow.Set.REQUEST_FLOW);
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        if (this.hasNoAuthorizationHeader(exc) || !this.validUser(exc)) {
            return this.deny(exc);
        }
        return Outcome.CONTINUE;
    }

    private boolean validUser(Exchange exc) {
        try {
            String username = this.getUsername(exc);
            this.userDataProvider.verify((Map<String, String>)ImmutableMap.of((Object)"username", (Object)username, (Object)"password", (Object)this.getPassword(exc)));
            exc.setProperty("membrane.security.schemes", List.of(HttpSecurityScheme.BASIC().username(username)));
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    private String getUsername(Exchange exc) {
        return this.getAuthorizationHeaderDecoded(exc).split(":", 2)[0];
    }

    private String getPassword(Exchange exc) {
        return this.getAuthorizationHeaderDecoded(exc).split(":", 2)[1];
    }

    private Outcome deny(Exchange exc) {
        ProblemDetails.security(this.router.isProduction(), this.getDisplayName()).statusCode(401).title("Unauthorized").buildAndSetResponse(exc);
        exc.getResponse().setHeader(HttpUtil.createHeaders(null, "WWW-Authenticate", "Basic realm=\"%s Authentication\"".formatted("Membrane API Gateway")));
        return Outcome.ABORT;
    }

    private boolean hasNoAuthorizationHeader(Exchange exc) {
        return exc.getRequest().getHeader().getFirstValue("Authorization") == null;
    }

    private String getAuthorizationHeaderDecoded(Exchange exc) {
        String value = exc.getRequest().getHeader().getFirstValue("Authorization");
        return new String(Base64.decodeBase64((byte[])value.substring(6).getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    public List<StaticUserDataProvider.User> getUsers() {
        UserDataProvider userDataProvider = this.userDataProvider;
        if (userDataProvider instanceof StaticUserDataProvider) {
            StaticUserDataProvider sud = (StaticUserDataProvider)userDataProvider;
            return sud.getUsers();
        }
        throw new UnsupportedOperationException("getUsers not implemented for this userDataProvider.");
    }

    @MCChildElement(order=20)
    public void setUsers(List<StaticUserDataProvider.User> users) {
        ((StaticUserDataProvider)this.userDataProvider).setUsers(users);
    }

    public UserDataProvider getUserDataProvider() {
        return this.userDataProvider;
    }

    @MCChildElement(order=10)
    public void setUserDataProvider(UserDataProvider userDataProvider) {
        this.userDataProvider = userDataProvider;
    }

    @Override
    public void init() {
        super.init();
        if (this.userDataProvider instanceof StaticUserDataProvider) {
            for (StaticUserDataProvider.User user : this.getUsers()) {
                if (!user.getAttributes().containsKey("name")) continue;
                String username = user.getAttributes().get("name");
                user.getAttributes().remove("name");
                user.getAttributes().put("username", username);
            }
        }
        this.userDataProvider.init(this.router);
    }

    @Override
    public String getShortDescription() {
        return "Authenticates incoming requests based on a fixed user list.";
    }

    @Override
    public String getLongDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getShortDescription());
        sb.append("<br/>");
        if (this.userDataProvider instanceof StaticUserDataProvider) {
            sb.append("Users: ");
            for (StaticUserDataProvider.User user : ((StaticUserDataProvider)this.userDataProvider).getUsers()) {
                sb.append(StringEscapeUtils.escapeHtml4((String)user.getUsername()));
                sb.append(", ");
            }
            sb.delete(sb.length() - 2, sb.length());
            sb.append("<br/>Passwords are not shown.");
        }
        return sb.toString();
    }
}

