/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.authentication.session;

import com.floreysoft.jmte.Engine;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.interceptor.authentication.session.NumericTokenProvider;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="emailTokenProvider", topLevel=false)
public class EmailTokenProvider
extends NumericTokenProvider {
    private static final Logger log = LoggerFactory.getLogger((String)EmailTokenProvider.class.getName());
    private boolean simulate = false;
    private String recipient;
    private String body;
    private String sender;
    private String subject;
    private String smtpHost;
    private String smtpUser;
    private int smtpPort = 25;
    private String smtpPassword;
    private boolean ssl = true;

    @Override
    public void init(Router router) {
    }

    @Override
    public void requestToken(Map<String, String> userAttributes) {
        HashMap<String, String> model = new HashMap<String, String>(userAttributes);
        model.put("token", this.generateToken(userAttributes));
        Engine engine = new Engine();
        String recipient = engine.transform(this.recipient, model);
        String body = engine.transform(this.body, model);
        String sender = engine.transform(this.sender, model);
        String subject = engine.transform(this.subject, model);
        if (this.simulate) {
            log.error("Send Email '" + subject + "' '" + body + "' from " + sender + " to " + recipient);
        } else {
            this.sendEmail(sender, recipient, subject, body);
        }
    }

    private void sendEmail(String sender, String recipient, String subject, String text) {
        try {
            Properties props = System.getProperties();
            props.put("mail.smtp.host", this.smtpHost);
            props.put("mail.smtp.port", "" + this.smtpPort);
            props.put("mail.smtp.socketFactory.port", "" + this.smtpPort);
            if (this.ssl) {
                props.put("mail.smtp.starttls.enable", "true");
                props.put("mail.smtp.starttls.required", "true");
            }
            if (this.smtpUser != null) {
                props.put("mail.smtp.auth", "true");
            }
            Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(EmailTokenProvider.this.smtpUser, EmailTokenProvider.this.smtpPassword);
                }
            });
            MimeMessage msg = EmailTokenProvider.getMimeMessage(sender, recipient, subject, text, session);
            Transport.send((Message)msg, (Address[])msg.getAllRecipients());
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    private static MimeMessage getMimeMessage(String sender, String recipient, String subject, String text, Session session) throws MessagingException {
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(sender));
        msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)recipient, (boolean)false));
        msg.setSubject(subject);
        msg.setText(text, StandardCharsets.UTF_8.name());
        msg.setSentDate(new Date());
        return msg;
    }

    public boolean isSimulate() {
        return this.simulate;
    }

    @MCAttribute
    public void setSimulate(boolean simulate) {
        this.simulate = simulate;
    }

    public String getRecipient() {
        return this.recipient;
    }

    @MCAttribute
    @Required
    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public String getBody() {
        return this.body;
    }

    @MCAttribute
    @Required
    public void setBody(String body) {
        this.body = body;
    }

    public String getSender() {
        return this.sender;
    }

    @MCAttribute
    @Required
    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getSubject() {
        return this.subject;
    }

    @MCAttribute
    @Required
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSmtpHost() {
        return this.smtpHost;
    }

    @MCAttribute
    @Required
    public void setSmtpHost(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    public String getSmtpUser() {
        return this.smtpUser;
    }

    @MCAttribute
    public void setSmtpUser(String smtpUser) {
        this.smtpUser = smtpUser;
    }

    public int getSmtpPort() {
        return this.smtpPort;
    }

    @MCAttribute
    public void setSmtpPort(int smtpPort) {
        this.smtpPort = smtpPort;
    }

    public String getSmtpPassword() {
        return this.smtpPassword;
    }

    @MCAttribute
    public void setSmtpPassword(String smtpPassword) {
        this.smtpPassword = smtpPassword;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    @MCAttribute
    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }
}

