/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.authentication.session;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.interceptor.authentication.session.UserDataProvider;
import com.predic8.membrane.core.interceptor.registration.SecurityUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

@MCElement(name="fileUserDataProvider")
public class FileUserDataProvider
implements UserDataProvider {
    private final Map<String, User> usersByName = new HashMap<String, User>();
    private String htpasswdPath;

    @MCAttribute
    public void setHtpasswdPath(String path) {
        this.htpasswdPath = path;
    }

    public String getHtpasswdPath() {
        return this.htpasswdPath;
    }

    @Override
    public Map<String, String> verify(Map<String, String> postData) {
        String username = postData.get("username");
        if (username == null) {
            throw new NoSuchElementException();
        }
        User userAttributes = this.getUsersByName().get(username);
        if (userAttributes == null) {
            throw new NoSuchElementException();
        }
        String pw = null;
        String postDataPassword = postData.get("password");
        String userHash = userAttributes.getPassword();
        String[] userHashSplit = userHash.split("\\$");
        String salt = userHashSplit[2];
        String algo = userHashSplit[1];
        pw = SecurityUtils.createPasswdCompatibleHash(algo, postDataPassword, salt);
        String pw2 = userAttributes.getPassword();
        if (pw2 == null || !pw2.equals(pw)) {
            throw new NoSuchElementException();
        }
        return userAttributes.getAttributes();
    }

    public Map<String, User> getUsersByName() {
        return this.usersByName;
    }

    @Override
    public void init(Router router) {
        List<String> lines;
        try {
            lines = Files.readAllLines(Paths.get(this.htpasswdPath, new String[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (String line : lines) {
            String[] parts = line.split(":");
            if (parts.length != 2) continue;
            User user = new User(parts[0], parts[1]);
            this.getUsersByName().put(user.getUsername(), user);
        }
    }

    public static class User {
        Map<String, String> attributes = new HashMap<String, String>();

        public User(String username, String password) {
            this.setUsername(username);
            this.setPassword(password);
        }

        public String getUsername() {
            return this.attributes.get("username");
        }

        public void setUsername(String value) {
            this.attributes.put("username", value);
        }

        public String getPassword() {
            return this.attributes.get("password");
        }

        public void setPassword(String value) {
            this.attributes.put("password", value);
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes.putAll(attributes);
        }
    }
}

