/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.authentication.session;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.config.security.SSLParser;
import com.predic8.membrane.core.interceptor.authentication.session.UserDataProvider;
import com.predic8.membrane.core.transport.ssl.SSLContext;
import com.predic8.membrane.core.transport.ssl.StaticSSLContext;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.net.SocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="ldapUserDataProvider", topLevel=false)
public class LDAPUserDataProvider
implements UserDataProvider {
    private static Logger log = LoggerFactory.getLogger((String)LDAPUserDataProvider.class.getName());
    String url;
    String base;
    String binddn;
    String bindpw;
    String searchPattern;
    int searchScope = 2;
    String passwordAttribute;
    String timeout = "1000";
    String connectTimeout = "1000";
    boolean readAttributesAsSelf = true;
    HashMap<String, String> attributeMap = new HashMap();
    AttributeMap map;
    SSLParser sslParser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, String> auth(String login, String password) throws NamingException {
        String uid;
        InitialDirContext ctx;
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.url);
        env.put("com.sun.jndi.ldap.read.timeout", this.timeout);
        env.put("com.sun.jndi.ldap.connect.timeout", this.connectTimeout);
        if (this.binddn != null) {
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", this.binddn);
            env.put("java.naming.security.credentials", this.bindpw);
        }
        if (this.sslParser != null) {
            env.put("java.naming.ldap.factory.socket", CustomSocketFactory.class.getName());
        }
        HashMap<String, String> userAttrs = new HashMap<String, String>();
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(CustomSocketFactory.class.getClassLoader());
            ctx = new InitialDirContext(env);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        try {
            uid = this.searchUser(login, userAttrs, ctx);
        }
        finally {
            ctx.close();
        }
        if (this.passwordAttribute != null) {
            if (!userAttrs.containsKey("_pass")) {
                throw new NoSuchElementException();
            }
            String pass = userAttrs.get("_pass");
            if (pass == null || !pass.startsWith("{x-plain}")) {
                throw new NoSuchElementException();
            }
            log.debug("found password");
            pass = pass.substring(9);
            if (!pass.equals(password)) {
                throw new NoSuchElementException();
            }
            userAttrs.remove("_pass");
        } else {
            InitialDirContext ctx2;
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", uid + "," + this.base);
            env.put("java.naming.security.credentials", password);
            ClassLoader old2 = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(CustomSocketFactory.class.getClassLoader());
                ctx2 = new InitialDirContext(env);
            }
            finally {
                Thread.currentThread().setContextClassLoader(old2);
            }
            try {
                if (this.readAttributesAsSelf) {
                    this.searchUser(login, userAttrs, ctx2);
                }
            }
            finally {
                ctx2.close();
            }
        }
        return userAttrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String searchUser(String login, HashMap<String, String> userAttrs, DirContext ctx) throws NamingException {
        String uid;
        SearchControls ctls = new SearchControls();
        ctls.setReturningObjFlag(true);
        ctls.setSearchScope(this.searchScope);
        String search = this.searchPattern.replaceAll(Pattern.quote("%LOGIN%"), LDAPUserDataProvider.escapeLDAPSearchFilter(login));
        log.debug("Searching LDAP for " + search);
        try (NamingEnumeration<SearchResult> answer = ctx.search(this.base, search, ctls);){
            if (!answer.hasMore()) {
                throw new NoSuchElementException();
            }
            log.debug("LDAP returned >=1 record.");
            SearchResult result = answer.next();
            uid = result.getName();
            for (Map.Entry<String, String> e : this.attributeMap.entrySet()) {
                log.debug("found LDAP attribute: " + e.getKey());
                Attribute a = result.getAttributes().get(e.getKey());
                if (a == null) continue;
                userAttrs.put(e.getValue(), a.get().toString());
            }
        }
        return uid;
    }

    private static final String escapeLDAPSearchFilter(String filter) {
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < filter.length(); ++i) {
            char curChar = filter.charAt(i);
            switch (curChar) {
                case '\\': {
                    sb.append("\\5c");
                    continue block7;
                }
                case '*': {
                    sb.append("\\2a");
                    continue block7;
                }
                case '(': {
                    sb.append("\\28");
                    continue block7;
                }
                case ')': {
                    sb.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    sb.append("\\00");
                    continue block7;
                }
                default: {
                    sb.append(curChar);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public Map<String, String> verify(Map<String, String> postData) {
        String username = postData.get("username");
        String password = postData.get("password");
        if (username == null || password == null) {
            throw new NoSuchElementException();
        }
        try {
            return this.auth(username, password);
        }
        catch (NoSuchElementException e) {
            throw e;
        }
        catch (AuthenticationException e) {
            log.debug("", (Throwable)e);
            throw new NoSuchElementException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getUrl() {
        return this.url;
    }

    @MCAttribute
    @Required
    public void setUrl(String url) {
        this.url = url;
    }

    public String getBase() {
        return this.base;
    }

    @MCAttribute
    @Required
    public void setBase(String base) {
        this.base = base;
    }

    public String getBinddn() {
        return this.binddn;
    }

    @MCAttribute
    public void setBinddn(String binddn) {
        this.binddn = binddn;
    }

    public String getBindpw() {
        return this.bindpw;
    }

    @MCAttribute
    public void setBindpw(String bindpw) {
        this.bindpw = bindpw;
    }

    public String getSearchPattern() {
        return this.searchPattern;
    }

    @MCAttribute
    @Required
    public void setSearchPattern(String searchPattern) {
        this.searchPattern = searchPattern;
    }

    public SearchScope getSearchScope() {
        return SearchScope.values()[this.searchScope];
    }

    @MCAttribute
    public void setSearchScope(SearchScope searchScope) {
        this.searchScope = searchScope.ordinal();
    }

    public String getPasswordAttribute() {
        return this.passwordAttribute;
    }

    @MCAttribute
    public void setPasswordAttribute(String passwordAttribute) {
        this.passwordAttribute = passwordAttribute;
        if (passwordAttribute != null) {
            this.attributeMap.put(passwordAttribute, "_pass");
        }
    }

    public String getTimeout() {
        return this.timeout;
    }

    @MCAttribute
    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getConnectTimeout() {
        return this.connectTimeout;
    }

    @MCAttribute
    public void setConnectTimeout(String connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public boolean isReadAttributesAsSelf() {
        return this.readAttributesAsSelf;
    }

    @MCAttribute
    public void setReadAttributesAsSelf(boolean readAttributesAsSelf) {
        this.readAttributesAsSelf = readAttributesAsSelf;
    }

    public HashMap<String, String> getAttributeMap() {
        return this.attributeMap;
    }

    public void setAttributeMap(HashMap<String, String> attributeMap) {
        this.attributeMap = attributeMap;
        if (this.passwordAttribute != null) {
            attributeMap.put(this.passwordAttribute, "_pass");
        }
    }

    public SSLParser getSslParser() {
        return this.sslParser;
    }

    @MCChildElement(order=100, allowForeign=true)
    public void setSslParser(SSLParser sslParser) {
        this.sslParser = sslParser;
    }

    @Override
    public void init(Router router) {
        if (this.passwordAttribute != null && this.readAttributesAsSelf) {
            throw new RuntimeException("@passwordAttribute is not compatible with @readAttributesAsSelf.");
        }
        if (this.map != null) {
            for (AttributeMap.Attribute a : this.map.getAttributes()) {
                this.attributeMap.put(a.getFrom(), a.getTo());
            }
        }
        if (this.passwordAttribute != null) {
            this.attributeMap.put(this.passwordAttribute, "_pass");
        }
        if (this.sslParser != null) {
            CustomSocketFactory.sslContext = new StaticSSLContext(this.sslParser, router.getResolverMap(), router.getBaseLocation());
        }
    }

    public AttributeMap getMap() {
        return this.map;
    }

    @MCChildElement(order=200)
    public void setMap(AttributeMap map) {
        this.map = map;
    }

    public static class CustomSocketFactory
    extends SocketFactory {
        public static SSLContext sslContext;
        public static int connectTimeout;
        private static CustomSocketFactory instance;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static CustomSocketFactory getDefault() {
            Class<CustomSocketFactory> clazz = CustomSocketFactory.class;
            synchronized (CustomSocketFactory.class) {
                if (instance == null) {
                    instance = new CustomSocketFactory();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return sslContext.createSocket(host, port, connectTimeout, host, null);
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
            return sslContext.createSocket(host, port, localHost, localPort, connectTimeout, host, null);
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            throw new RuntimeException("not implemented");
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            throw new RuntimeException("not implemented");
        }

        @Override
        public Socket createSocket() throws IOException {
            return sslContext.createSocket();
        }

        static {
            connectTimeout = 60000;
        }
    }

    public static enum SearchScope {
        OBJECT,
        ONELEVEL,
        SUBTREE;

    }

    @MCElement(name="map", topLevel=false, id="ldapUserDataProvider-map")
    public static class AttributeMap {
        private List<Attribute> attributes = new ArrayList<Attribute>();

        public List<Attribute> getAttributes() {
            return this.attributes;
        }

        @MCChildElement
        public void setAttributes(List<Attribute> attributes) {
            this.attributes = attributes;
        }

        @MCElement(name="attribute", topLevel=false)
        public static class Attribute {
            String from;
            String to;

            public String getFrom() {
                return this.from;
            }

            @MCAttribute
            @Required
            public void setFrom(String from) {
                this.from = from;
            }

            public String getTo() {
                return this.to;
            }

            @MCAttribute
            @Required
            public void setTo(String to) {
                this.to = to;
            }
        }
    }
}

