/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.authentication.session;

import com.predic8.membrane.core.interceptor.authentication.session.TokenProvider;
import java.security.SecureRandom;
import java.util.Map;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NumericTokenProvider
implements TokenProvider {
    Logger log = LoggerFactory.getLogger(NumericTokenProvider.class);
    private final SecureRandom r = new SecureRandom();

    private long hash(Map<String, String> userAttributes) {
        long hash = 0L;
        for (Map.Entry<String, String> entry : userAttributes.entrySet()) {
            hash += (long)entry.getKey().hashCode();
            hash += (long)(3 * entry.getValue().hashCode());
        }
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String generateToken(Map<String, String> userAttributes) {
        int t = (int)this.hash(userAttributes);
        SecureRandom secureRandom = this.r;
        synchronized (secureRandom) {
            t ^= this.r.nextInt();
        }
        t = Math.abs(t % 1000000);
        String token = String.format("%06d", t);
        Map<String, String> map = userAttributes;
        synchronized (map) {
            userAttributes.put("token", token);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void verifyToken(Map<String, String> userAttributes, String token) {
        String t1;
        Map<String, String> map = userAttributes;
        synchronized (map) {
            t1 = userAttributes.get("token");
        }
        if (t1 == null || !t1.equals(token)) {
            this.log.info("The given token was not equal to generated token.\nGenerated token: \"" + t1 + "\"\nGiven token: \"" + token + "\"\nUser: \"" + userAttributes.get("username") + "\"");
            throw new NoSuchElementException();
        }
    }
}

