/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.authentication.session;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.core.interceptor.authentication.session.NumericTokenProvider;
import java.security.InvalidParameterException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SMSTokenProvider
extends NumericTokenProvider {
    private static Logger log = LoggerFactory.getLogger((String)SMSTokenProvider.class.getName());
    protected String prefixText = "Token: ";
    private boolean simulate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestToken(Map<String, String> userAttributes) {
        String recipientNumber;
        String token = this.generateToken(userAttributes);
        Map<String, String> map = userAttributes;
        synchronized (map) {
            recipientNumber = userAttributes.get("sms");
        }
        if (recipientNumber == null) {
            throw new InvalidParameterException("User does not have the 'sms' attribute");
        }
        recipientNumber = this.normalizeNumber(recipientNumber);
        String text = this.prefixText + token;
        if (this.simulate) {
            log.error("Send SMS '" + text + "' to " + recipientNumber);
        } else {
            this.sendSMS(text, recipientNumber);
        }
    }

    protected abstract void sendSMS(String var1, String var2);

    protected abstract String normalizeNumber(String var1);

    public String getPrefixText() {
        return this.prefixText;
    }

    @MCAttribute
    public void setPrefixText(String prefixText) {
        this.prefixText = prefixText;
    }

    public boolean isSimulate() {
        return this.simulate;
    }

    @MCAttribute
    public void setSimulate(boolean simulate) {
        this.simulate = simulate;
    }
}

