/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.authentication.session;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.config.AbstractXmlElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.authentication.session.CleanupThread;
import com.predic8.membrane.core.proxies.Proxy;
import com.predic8.membrane.core.proxies.SSLableProxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@MCElement(name="sessionManager", topLevel=false)
public class SessionManager
extends AbstractXmlElement
implements CleanupThread.Cleaner {
    private String cookieName;
    private long timeout;
    private String domain;
    protected final HashMap<String, Session> sessions = new HashMap();
    protected static final String SESSION_ID = "SESSION_ID";
    protected static final String SESSION = "SESSION";

    @Override
    protected void parseAttributes(XMLStreamReader token) {
        this.cookieName = token.getAttributeValue("", "cookieName");
        this.timeout = Long.parseLong((String)StringUtils.defaultIfEmpty((CharSequence)token.getAttributeValue("", "timeout"), (CharSequence)"300000"));
        this.domain = token.getAttributeValue("", "domain");
    }

    public void init(Router router) {
        this.cookieName = (String)StringUtils.defaultIfEmpty((CharSequence)this.cookieName, (CharSequence)"SESSIONID");
        this.timeout = this.timeout == 0L ? 300000L : this.timeout;
    }

    public void postProcess(Exchange exc) {
        String cookieValue = (String)exc.getProperty(SESSION_ID);
        if (cookieValue != null && exc.getResponse() != null) {
            exc.getResponse().getHeader().addCookieSession(this.cookieName, cookieValue);
        }
    }

    public Session getOrCreateSession(Exchange exc) {
        Session s = this.getSession(exc);
        if (s == null) {
            s = this.createSession(exc);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(Exchange exc) {
        String id = exc.getRequest().getHeader().getFirstCookie(this.cookieName);
        if (id != null) {
            HashMap<String, Session> hashMap = this.sessions;
            synchronized (hashMap) {
                this.sessions.remove(id);
            }
            return;
        }
        Session s = this.getSession(exc);
        this.removeSession(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(Session s) {
        if (s != null) {
            HashMap<String, Session> hashMap = this.sessions;
            synchronized (hashMap) {
                List<String> remove = this.sessions.keySet().stream().filter(sId -> {
                    Session other = this.sessions.get(sId);
                    return s == other;
                }).toList();
                remove.forEach(this.sessions::remove);
            }
        }
    }

    private String generateSessionID() {
        return UUID.randomUUID().toString();
    }

    public Session getSession(Exchange exc) {
        Session s = (Session)exc.getProperty(SESSION);
        if (s != null) {
            return s;
        }
        String id = exc.getRequest().getHeader().getFirstCookie(this.cookieName);
        if (id == null) {
            return null;
        }
        return this.getSession(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session getSession(String id) {
        Session s;
        HashMap<String, Session> hashMap = this.sessions;
        synchronized (hashMap) {
            s = this.sessions.get(id);
        }
        if (s != null) {
            s.touch();
        }
        return s;
    }

    public Session createSession(Exchange exc) {
        String id = this.generateSessionID();
        return this.createSession(exc, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session createSession(Exchange exc, String id) {
        Session s = new Session();
        HashMap<String, Session> hashMap = this.sessions;
        synchronized (hashMap) {
            this.sessions.put(id, s);
        }
        String cookieValue = this.getCookieValue(exc, id);
        exc.setProperty(SESSION_ID, cookieValue);
        exc.setProperty(SESSION, s);
        if (exc.getResponse() != null) {
            exc.getResponse().getHeader().addCookieSession(this.cookieName, cookieValue);
        }
        return s;
    }

    @NotNull
    protected String getCookieValue(Exchange exc, String value) {
        return value + "; " + (String)(this.domain != null ? "Domain=" + this.domain + "; " : "") + "Path=/" + SessionManager.getSecureString(exc);
    }

    @NotNull
    protected static String getSecureString(Exchange exc) {
        Proxy proxy = exc.getProxy();
        if (!(proxy instanceof SSLableProxy)) {
            return "";
        }
        SSLableProxy sp = (SSLableProxy)proxy;
        return sp.isInboundSSL() ? "; Secure" : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        long death = System.currentTimeMillis() - this.timeout;
        ArrayList<String> removeUs = new ArrayList<String>();
        HashMap<String, Session> hashMap = this.sessions;
        synchronized (hashMap) {
            for (Map.Entry<String, Session> e : this.sessions.entrySet()) {
                if (e.getValue().getLastUse() >= death) continue;
                removeUs.add(e.getKey());
            }
            for (String sessionId : removeUs) {
                this.sessions.remove(sessionId);
            }
        }
    }

    public String getCookieName() {
        return this.cookieName;
    }

    @MCAttribute
    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public long getTimeout() {
        return this.timeout;
    }

    @MCAttribute
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public String getDomain() {
        return this.domain;
    }

    @MCAttribute
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public static class Session {
        private Map<String, String> userAttributes = new HashMap<String, String>();
        private int level = 0;
        private long lastUse;
        private String userName;

        public synchronized boolean isAuthorized() {
            return this.level == 2;
        }

        public synchronized boolean isPreAuthorized() {
            return this.level == 1;
        }

        public synchronized Map<String, String> getUserAttributes() {
            return this.userAttributes;
        }

        public synchronized void setUserAttributes(Map<String, String> userAttributes) {
            this.userAttributes = userAttributes;
        }

        public synchronized void clear() {
            this.level = 0;
            this.userAttributes = new HashMap<String, String>();
        }

        public synchronized void preAuthorize(String userName, Map<String, String> userAttributes) {
            this.userName = userName;
            this.userAttributes.putAll(userAttributes);
            this.level = 1;
        }

        public synchronized void authorize() {
            this.level = 2;
        }

        public synchronized void touch() {
            this.lastUse = System.currentTimeMillis();
        }

        public synchronized long getLastUse() {
            return this.lastUse;
        }

        public synchronized String getUserName() {
            return this.userName;
        }

        protected synchronized void setUserName(String userName) {
            this.userName = userName;
        }

        public synchronized void clearCredentials() {
            this.getUserAttributes().remove("password");
            this.getUserAttributes().remove("client_secret");
        }

        protected synchronized int getLevel() {
            return this.level;
        }

        protected synchronized void setLevel(int level) {
            this.level = level;
        }
    }
}

