/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.authentication.session.totp;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import javax.crypto.Mac;

public class PasscodeGenerator {
    private static final int MAX_PASSCODE_LENGTH = 9;
    public static final int INTERVAL = 30;
    private static final int PASS_CODE_LENGTH = 6;
    private static final int ADJACENT_INTERVALS = 1;
    private final Signer signer;
    private final int codeLength;

    public PasscodeGenerator(Mac mac) {
        this(mac, 6);
    }

    public PasscodeGenerator(Signer signer) {
        this(signer, 6);
    }

    public PasscodeGenerator(Mac mac, int passCodeLength) {
        this((byte[] data) -> mac.doFinal(data), passCodeLength);
    }

    public PasscodeGenerator(Signer signer, int passCodeLength) {
        if (passCodeLength < 0 || passCodeLength > 9) {
            throw new IllegalArgumentException("PassCodeLength must be between 1 and 9 digits.");
        }
        this.signer = signer;
        this.codeLength = passCodeLength;
    }

    private String padOutput(int value) {
        Object result = Integer.toString(value);
        for (int i = ((String)result).length(); i < this.codeLength; ++i) {
            result = "0" + (String)result;
        }
        return result;
    }

    public String generateResponseCode(long state) throws GeneralSecurityException {
        byte[] value = ByteBuffer.allocate(8).putLong(state).array();
        return this.generateResponseCode(value);
    }

    public String generateResponseCode(long state, byte[] challenge) throws GeneralSecurityException {
        if (challenge == null) {
            return this.generateResponseCode(state);
        }
        byte[] value = ByteBuffer.allocate(8 + challenge.length).putLong(state).put(challenge, 0, challenge.length).array();
        return this.generateResponseCode(value);
    }

    public String generateResponseCode(byte[] challenge) throws GeneralSecurityException {
        byte[] hash = this.signer.sign(challenge);
        int offset = hash[hash.length - 1] & 0xF;
        int truncatedHash = this.hashToInt(hash, offset) & Integer.MAX_VALUE;
        int pinValue = truncatedHash % (int)Math.pow(10.0, this.codeLength);
        return this.padOutput(pinValue);
    }

    private int hashToInt(byte[] bytes, int start) {
        int val;
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(bytes, start, bytes.length - start));
        try {
            val = input.readInt();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return val;
    }

    public boolean verifyResponseCode(long challenge, String response) throws GeneralSecurityException {
        String expectedResponse = this.generateResponseCode(challenge, null);
        return expectedResponse.equals(response);
    }

    public boolean verifyTimeoutCode(long currentInterval, String timeoutCode) throws GeneralSecurityException {
        return this.verifyTimeoutCode(timeoutCode, currentInterval, 1, 1);
    }

    public boolean verifyTimeoutCode(String timeoutCode, long currentInterval, int pastIntervals, int futureIntervals) throws GeneralSecurityException {
        pastIntervals = Math.max(pastIntervals, 0);
        futureIntervals = Math.max(futureIntervals, 0);
        for (int i = -pastIntervals; i <= futureIntervals; ++i) {
            String candidate = this.generateResponseCode(currentInterval - (long)i, null);
            if (!candidate.equals(timeoutCode)) continue;
            return true;
        }
        return false;
    }

    static interface Signer {
        public byte[] sign(byte[] var1) throws GeneralSecurityException;
    }
}

