/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.authentication.session.totp;

public class TotpCounter {
    private final long mTimeStep;
    private final long mStartTime;

    public TotpCounter(long timeStep) {
        this(timeStep, 0L);
    }

    public TotpCounter(long timeStep, long startTime) {
        if (timeStep < 1L) {
            throw new IllegalArgumentException("Time step must be positive: " + timeStep);
        }
        TotpCounter.assertValidTime(startTime);
        this.mTimeStep = timeStep;
        this.mStartTime = startTime;
    }

    public long getTimeStep() {
        return this.mTimeStep;
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    public long getValueAtTime(long time) {
        TotpCounter.assertValidTime(time);
        long timeSinceStartTime = time - this.mStartTime;
        if (timeSinceStartTime >= 0L) {
            return timeSinceStartTime / this.mTimeStep;
        }
        return (timeSinceStartTime - (this.mTimeStep - 1L)) / this.mTimeStep;
    }

    public long getValueStartTime(long value) {
        return this.mStartTime + value * this.mTimeStep;
    }

    private static void assertValidTime(long time) {
        if (time < 0L) {
            throw new IllegalArgumentException("Negative time: " + time);
        }
    }
}

