/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.balancer;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.balancer.BalancerUtil;
import com.predic8.membrane.core.util.URLParamUtil;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="clusterNotification")
public class ClusterNotificationInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)ClusterNotificationInterceptor.class.getName());
    private final Pattern urlPattern = Pattern.compile("/clustermanager/(up|down|takeout)/?\\??(.*)");
    private boolean validateSignature = false;
    private int timeout = 0;
    private String keyHex;

    public ClusterNotificationInterceptor() {
        this.name = "cluster notification";
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        Map<String, String> params;
        log.debug(exc.getOriginalRequestUri());
        Matcher m = this.urlPattern.matcher(exc.getOriginalRequestUri());
        if (!m.matches()) {
            return Outcome.CONTINUE;
        }
        log.debug("request received: {}", (Object)m.group(1));
        if (this.validateSignature && !this.getParams(exc).containsKey("data")) {
            exc.setResponse(Response.forbidden().build());
            return Outcome.ABORT;
        }
        try {
            params = this.validateSignature ? this.getDecryptedParams(this.getParams(exc).get("data")) : this.getParams(exc);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).detail("Could not decrypt parameters!").exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        if (this.isTimedout(params)) {
            exc.setResponse(Response.forbidden().build());
            return Outcome.ABORT;
        }
        this.updateClusterManager(m, params);
        exc.setResponse(Response.noContent().build());
        return Outcome.RETURN;
    }

    private void updateClusterManager(Matcher m, Map<String, String> params) {
        if ("up".equals(m.group(1))) {
            BalancerUtil.up(this.router, this.getBalancerParam(params), this.getClusterParam(params), params.get("host"), this.getPortParam(params));
        } else if ("down".equals(m.group(1))) {
            BalancerUtil.down(this.router, this.getBalancerParam(params), this.getClusterParam(params), params.get("host"), this.getPortParam(params));
        } else {
            BalancerUtil.takeout(this.router, this.getBalancerParam(params), this.getClusterParam(params), params.get("host"), this.getPortParam(params));
        }
    }

    private boolean isTimedout(Map<String, String> params) {
        return this.timeout > 0 && System.currentTimeMillis() - Long.parseLong(params.get("time")) > (long)this.timeout;
    }

    private Map<String, String> getDecryptedParams(String data) throws Exception {
        Cipher cipher = Cipher.getInstance("AES");
        SecretKeySpec skeySpec = new SecretKeySpec(Hex.decodeHex((char[])this.keyHex.toCharArray()), "AES");
        cipher.init(2, skeySpec);
        return URLParamUtil.parseQueryString(new String(cipher.doFinal(Base64.decodeBase64((byte[])data.getBytes(StandardCharsets.UTF_8))), StandardCharsets.UTF_8), URLParamUtil.DuplicateKeyOrInvalidFormStrategy.ERROR);
    }

    private int getPortParam(Map<String, String> params) {
        return Integer.parseInt(params.get("port"));
    }

    private String getClusterParam(Map<String, String> params) {
        return params.get("cluster") == null ? "Default" : params.get("cluster");
    }

    private String getBalancerParam(Map<String, String> params) {
        return params.get("balancer") == null ? "Default" : params.get("balancer");
    }

    private Map<String, String> getParams(Exchange exc) {
        String uri = exc.getOriginalRequestUri();
        int qStart = uri.indexOf(63);
        if (qStart == -1 || qStart + 1 == uri.length()) {
            return new HashMap<String, String>();
        }
        return URLParamUtil.parseQueryString(exc.getOriginalRequestUri().substring(qStart + 1), URLParamUtil.DuplicateKeyOrInvalidFormStrategy.ERROR);
    }

    public boolean isValidateSignature() {
        return this.validateSignature;
    }

    @MCAttribute
    public void setValidateSignature(boolean validateSignature) {
        this.validateSignature = validateSignature;
    }

    public int getTimeout() {
        return this.timeout;
    }

    @MCAttribute
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getKeyHex() {
        return this.keyHex;
    }

    @MCAttribute
    public void setKeyHex(String keyHex) {
        this.keyHex = keyHex;
    }

    @Override
    public String getShortDescription() {
        return "Sets the status of load-balancer nodes to UP or DOWN, based on the request attributes.";
    }
}

