/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.balancer;

import com.google.common.base.Objects;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.config.AbstractXmlElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.proxies.StatisticCollector;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

@MCElement(name="node", topLevel=false)
public class Node
extends AbstractXmlElement {
    private String host;
    private int port;
    private volatile long lastUpTime;
    private volatile Status status;
    private AtomicInteger counter = new AtomicInteger();
    private AtomicInteger threads = new AtomicInteger();
    private ConcurrentHashMap<Integer, StatisticCollector> statusCodes = new ConcurrentHashMap();

    public Node(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public Node() {
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof Node && this.host.equals(((Node)obj).getHost()) && this.port == ((Node)obj).getPort();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.host, this.port});
    }

    public int getLost() {
        int received = 0;
        for (StatisticCollector statisticCollector : this.statusCodes.values()) {
            received += statisticCollector.getCount();
        }
        return this.counter.get() - received - this.threads.get();
    }

    public double getErrors() {
        int successes = 0;
        int all = 0;
        for (Map.Entry<Integer, StatisticCollector> e : this.statusCodes.entrySet()) {
            int count = e.getValue().getCount();
            all += count;
            if (e.getKey() >= 500 || e.getKey() <= 0) continue;
            successes += count;
        }
        return all == 0 ? 0.0 : 1.0 - (double)successes / (double)all;
    }

    public long getLastUpTime() {
        return this.lastUpTime;
    }

    public void setLastUpTime(long lastUpTime) {
        this.lastUpTime = lastUpTime;
    }

    public String getHost() {
        return this.host;
    }

    @MCAttribute
    @Required
    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    @MCAttribute
    public void setPort(int port) {
        this.port = port;
    }

    public boolean isUp() {
        return this.status == Status.UP;
    }

    public boolean isDown() {
        return this.status == Status.DOWN;
    }

    public boolean isTakeOut() {
        return this.status == Status.TAKEOUT;
    }

    public void setStatus(Status status) {
        if (status == Status.DOWN) {
            this.threads.set(0);
        }
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    public String toString() {
        return "[" + this.host + ":" + this.port + "]";
    }

    public int getCounter() {
        return this.counter.get();
    }

    public void incCounter() {
        this.counter.incrementAndGet();
    }

    public void clearCounter() {
        this.counter.set(0);
        this.statusCodes.clear();
    }

    private StatisticCollector getStatisticCollectorByStatusCode(int code) {
        StatisticCollector sc = this.statusCodes.get(code);
        if (sc == null) {
            sc = new StatisticCollector(true);
            StatisticCollector sc2 = this.statusCodes.putIfAbsent(code, sc);
            if (sc2 != null) {
                sc = sc2;
            }
        }
        return sc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectStatisticsFrom(Exchange exc) {
        StatisticCollector sc;
        StatisticCollector statisticCollector = sc = this.getStatisticCollectorByStatusCode(exc.getResponse().getStatusCode());
        synchronized (statisticCollector) {
            sc.collectFrom(exc);
        }
    }

    public void addThread() {
        if (!this.isUp()) {
            return;
        }
        this.threads.incrementAndGet();
    }

    public void removeThread() {
        if (!this.isUp()) {
            return;
        }
        this.threads.incrementAndGet();
    }

    public int getThreads() {
        return this.threads.get();
    }

    public Map<Integer, StatisticCollector> getStatisticsByStatusCodes() {
        return this.statusCodes;
    }

    @Override
    public void write(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement("node");
        out.writeAttribute("host", this.host);
        out.writeAttribute("port", "" + this.port);
        out.writeEndElement();
    }

    @Override
    protected void parseAttributes(XMLStreamReader token) {
        this.host = token.getAttributeValue("", "host");
        this.port = Integer.parseInt(token.getAttributeValue("", "port") != null ? token.getAttributeValue("", "port") : "80");
    }

    public String getDestinationURL(Exchange exc) {
        return "http://" + this.getHost() + (String)(this.getPort() == 0 ? "" : ":" + this.getPort()) + exc.getRequest().getUri();
    }

    public static enum Status {
        UP,
        DOWN,
        TAKEOUT;

    }
}

