/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.balancer;

import com.predic8.membrane.core.interceptor.balancer.Cluster;
import com.predic8.membrane.core.interceptor.balancer.Session;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionCleanupThread
extends Thread {
    private static Logger log = LoggerFactory.getLogger((String)SessionCleanupThread.class.getName());
    public static final long DEFAULT_TIMEOUT = 3600000L;
    private Map<String, Cluster> clusters;
    private long sessionTimeout = 3600000L;

    public SessionCleanupThread(Map<String, Cluster> clusters) {
        super("SessionCleanupThread");
        this.clusters = clusters;
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            SessionCleanupThread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        log.debug("SessionCleanupThread started");
        while (!SessionCleanupThread.interrupted()) {
            SessionCleanupThread sessionCleanupThread = this;
            synchronized (sessionCleanupThread) {
                long time = System.currentTimeMillis();
                int size = 0;
                int cleaned = 0;
                for (Cluster c : this.clusters.values()) {
                    Map<String, Session> map = c.getSessions();
                    synchronized (map) {
                        size = c.getSessions().size();
                        cleaned = this.cleanupSessions(c);
                    }
                }
                if (cleaned != 0) {
                    log.debug(cleaned + " sessions removed of " + size + " in " + (System.currentTimeMillis() - time) + "ms");
                }
            }
            try {
                SessionCleanupThread.sleep(15000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private int cleanupSessions(Cluster c) {
        Collection<Session> ss = c.getSessions().values();
        Iterator<Session> sIt = ss.iterator();
        int cleaned = 0;
        long now = System.currentTimeMillis();
        while (sIt.hasNext()) {
            Session s = sIt.next();
            if (now - s.getLastUsed() <= this.sessionTimeout) continue;
            ++cleaned;
            sIt.remove();
        }
        return cleaned;
    }
}

