/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.beautifier;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.util.TextUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="beautifier")
public class BeautifierInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(BeautifierInterceptor.class);
    private final ObjectWriter ow = new ObjectMapper().writerWithDefaultPrettyPrinter();
    private final ObjectMapper om = new ObjectMapper();

    public BeautifierInterceptor() {
        this.name = "beautifier";
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        return this.handleInternal(exc.getRequest());
    }

    @Override
    public Outcome handleResponse(Exchange exc) {
        return this.handleInternal(exc.getResponse());
    }

    private Outcome handleInternal(Message msg) {
        if (msg.isJSON()) {
            this.beautifyJSON(msg);
            return Outcome.CONTINUE;
        }
        if (msg.isXML()) {
            BeautifierInterceptor.beautifyXML(msg);
        }
        return Outcome.CONTINUE;
    }

    private static void beautifyXML(Message msg) {
        try {
            InputStreamReader reader = new InputStreamReader(msg.getBodyAsStream(), msg.getHeader().getCharset());
            msg.setBodyContent(TextUtil.formatXML(reader).getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            log.warn("Error parsing XML: {}", (Object)e.getMessage());
        }
    }

    private void beautifyJSON(Message msg) {
        try {
            JsonNode node = this.om.readTree(msg.getBodyAsStreamDecoded());
            msg.setBodyContent(this.ow.writeValueAsBytes((Object)node));
        }
        catch (IOException e) {
            log.warn("Error parsing JSON: {}", (Object)e.getMessage());
        }
    }

    @Override
    public String getShortDescription() {
        return "Pretty printing. Applies, if the body is JSON.";
    }
}

