/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.cache;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.cache.CacheInterceptor;
import com.predic8.membrane.core.interceptor.cache.Node;
import com.predic8.membrane.core.util.ByteUtil;
import java.io.IOException;
import java.text.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PositiveNode
extends Node {
    private static final long serialVersionUID = 1L;
    static final Logger log = LoggerFactory.getLogger((String)PositiveNode.class.getName());
    byte[] content;
    long lastModified;
    String contentType;
    String inResponseToAccept;
    String location;
    int status;

    public PositiveNode(Exchange exchange) throws IOException, ParseException {
        Response response = exchange.getResponse();
        this.content = ByteUtil.getByteArrayData(response.getBodyAsStreamDecoded());
        this.contentType = response.getHeader().getFirstValue("Content-Type");
        this.lastModified = CacheInterceptor.fromRFC(response.getHeader().getFirstValue("Last-Modified"));
        this.inResponseToAccept = exchange.getRequest().getHeader().getNormalizedValue("Accept");
        this.location = response.getHeader().getFirstValue("Location");
        this.status = response.getStatusCode();
    }

    @Override
    public Response toResponse(Request request) {
        String ifModifiedSince = request.getHeader().getFirstValue("If-Modified-Since");
        if (ifModifiedSince != null) {
            try {
                if (this.lastModified <= CacheInterceptor.fromRFC(ifModifiedSince)) {
                    return Response.notModified(CacheInterceptor.toRFC(System.currentTimeMillis())).build();
                }
            }
            catch (Exception e) {
                log.warn("", (Throwable)e);
            }
        }
        Response.ResponseBuilder builder = Response.ok();
        if (this.status >= 300 && this.status < 400) {
            builder.status(this.status, "Moved.");
        }
        if (this.contentType != null) {
            builder.contentType(this.contentType);
        }
        if (this.location != null) {
            builder.header("Location", this.location);
        }
        if (this.lastModified != 0L) {
            return builder.header("Last-Modified", CacheInterceptor.toRFC(this.lastModified)).body(this.content).build();
        }
        return builder.body(this.content).build();
    }

    @Override
    public boolean canSatisfy(Request request) {
        String accept = request.getHeader().getFirstValue("accept");
        if (accept != null) {
            if (this.inResponseToAccept.equals(accept)) {
                return true;
            }
            if (this.inResponseToAccept.startsWith(accept + ",") || this.inResponseToAccept.endsWith("," + accept) || this.inResponseToAccept.contains("," + accept + ",")) {
                return true;
            }
            if (accept.endsWith("*")) {
                accept = accept.substring(0, accept.length() - 1);
                return this.contentType != null && this.contentType.startsWith(accept);
            }
            CacheInterceptor.log.warn("Cannot check cache node satisfaction: 'Accept: " + accept + "'");
            return false;
        }
        return true;
    }
}

