/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.flow;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.flow.AbstractFlowInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="abort", topLevel=false)
public class AbortInterceptor
extends AbstractFlowInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AbortInterceptor.class);

    public AbortInterceptor() {
        this.name = "abort";
        this.setFlow(Interceptor.Flow.Set.RESPONSE_ABORT_FLOW);
    }

    @Override
    public void handleAbort(Exchange exchange) {
        for (int i = this.interceptors.size() - 1; i >= 0; --i) {
            Interceptor interceptor = (Interceptor)this.interceptors.get(i);
            if (!interceptor.handlesResponses()) continue;
            log.debug("Invoking handleResponse() on {}", (Object)interceptor);
            try {
                interceptor.handleResponse(exchange);
                continue;
            }
            catch (Exception e) {
                AbortInterceptor.createProblemDetails("abort", interceptor, exchange, e);
            }
        }
    }
}

