/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.flow;

import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFlowInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AbstractFlowInterceptor.class);
    protected List<Interceptor> interceptors = new ArrayList<Interceptor>();

    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    @MCChildElement(allowForeign=true)
    public void setInterceptors(List<Interceptor> interceptors) {
        this.interceptors = interceptors;
    }

    @Override
    public void init() {
        super.init();
        for (Interceptor i : this.interceptors) {
            i.init(this.router);
        }
    }

    protected static void createProblemDetails(String flow, Interceptor interceptor, Exchange exc, Exception e) {
        String msg = "Aborting! Exception caused by %s %s during %s flow.".formatted(exc.getRequest().getUri(), flow, interceptor.getDisplayName());
        log.warn(msg, (Throwable)e);
        ProblemDetails.internal(false, "flow-interceptor").detail(msg).component(interceptor.getDisplayName()).exception(e).buildAndSetResponse(exc);
    }
}

