/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.flow;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.HeaderField;
import com.predic8.membrane.core.interceptor.HTTPClientInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.lang.AbstractExchangeExpressionInterceptor;
import com.predic8.membrane.core.lang.ExchangeExpressionException;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="call")
public class CallInterceptor
extends AbstractExchangeExpressionInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)CallInterceptor.class.getName());
    private static HTTPClientInterceptor hcInterceptor;
    private static final List<String> REMOVE_HEADERS;

    @Override
    public void init() {
        super.init();
        hcInterceptor = new HTTPClientInterceptor();
        hcInterceptor.init(this.router);
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        return this.handleInternal(exc);
    }

    @Override
    public Outcome handleResponse(Exchange exc) {
        return this.handleInternal(exc);
    }

    private Outcome handleInternal(Exchange exc) {
        List<String> oldDest = exc.getDestinations();
        Outcome outcome = this.doCall(exc);
        exc.setDestinations(oldDest);
        return outcome;
    }

    @NotNull
    private Outcome doCall(Exchange exc) {
        try {
            exc.setDestinations(List.of(this.exchangeExpression.evaluate(exc, Interceptor.Flow.REQUEST, String.class)));
        }
        catch (ExchangeExpressionException e) {
            e.provideDetails(ProblemDetails.internal(this.getRouter().isProduction(), this.getDisplayName())).addSubSee("expression-evaluation").buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        log.debug("Calling {}", exc.getDestinations());
        try {
            Outcome outcome = hcInterceptor.handleRequest(exc);
            if (outcome == Outcome.ABORT) {
                log.warn("Aborting. Error calling {}", exc.getDestinations());
                return Outcome.ABORT;
            }
            exc.getRequest().setBodyContent(exc.getResponse().getBody().getContent());
            CallInterceptor.copyHeadersFromResponseToRequest(exc);
            exc.getRequest().getHeader().setContentType(exc.getResponse().getHeader().getContentType());
            log.debug("Outcome of call {}", (Object)outcome);
            return Outcome.CONTINUE;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).addSubSee("internal-calling").detail("Internal call").exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
    }

    static void copyHeadersFromResponseToRequest(Exchange exc) {
        Arrays.stream(exc.getResponse().getHeader().getAllHeaderFields()).forEach(headerField -> {
            for (String rmHeader : REMOVE_HEADERS) {
                if (!headerField.getHeaderName().getName().equalsIgnoreCase(rmHeader)) continue;
                return;
            }
            exc.getRequest().getHeader().add((HeaderField)headerField);
        });
    }

    @MCAttribute
    @Required
    public void setUrl(String url) {
        this.expression = url;
    }

    public String getUrl() {
        return this.expression;
    }

    @Override
    public String getDisplayName() {
        return "call";
    }

    @Override
    public String getShortDescription() {
        return "Calls %s".formatted(this.expression);
    }

    static {
        REMOVE_HEADERS = List.of("Server", "Transfer-Encoding", "Content-Encoding");
    }
}

