/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.flow;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.util.ConfigurationException;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="destination")
public class DestinationInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)DestinationInterceptor.class.getName());
    private String url;

    @Override
    public void init() {
        super.init();
        if (this.url == null) {
            throw new ConfigurationException("<destination> needs a valid url!\n\ne.g.:\n\n<destination url=\"https://api.predic8.de\">\n");
        }
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        exc.getDestinations().clear();
        exc.getDestinations().add(this.url);
        exc.setOriginalRequestUri(this.url);
        log.debug("Set destination to: {}", (Object)this.url);
        return Outcome.CONTINUE;
    }

    public String getUrl() {
        return this.url;
    }

    @MCAttribute
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public EnumSet<Interceptor.Flow> getFlow() {
        return Interceptor.Flow.Set.REQUEST_FLOW;
    }
}

