/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.flow;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.flow.AbstractFlowInterceptor;
import com.predic8.membrane.core.lang.ExchangeExpression;
import com.predic8.membrane.core.lang.ExchangeExpressionException;
import com.predic8.membrane.core.util.ConfigurationException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="for")
public class ForInterceptor
extends AbstractFlowInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ForInterceptor.class);
    private String in;
    private ExchangeExpression.Language language = ExchangeExpression.Language.SPEL;
    private ExchangeExpression exchangeExpression;

    @Override
    public void init() {
        super.init();
        try {
            this.exchangeExpression = ExchangeExpression.newInstance(this.router, this.language, this.in);
        }
        catch (ConfigurationException ce) {
            throw new ConfigurationException(ce.getMessage() + "\n<for in=\"%s\">".formatted(this.in), ce.getCause());
        }
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        return this.handleInternal(exc, Interceptor.Flow.REQUEST);
    }

    @Override
    public Outcome handleResponse(Exchange exc) {
        return this.handleInternal(exc, Interceptor.Flow.RESPONSE);
    }

    private Outcome handleInternal(Exchange exc, Interceptor.Flow flow) {
        Object o;
        try {
            o = this.exchangeExpression.evaluate(exc, flow, Object.class);
        }
        catch (ExchangeExpressionException e) {
            ProblemDetails pd = ProblemDetails.internal(this.router.isProduction(), this.getDisplayName());
            e.provideDetails(pd).detail("Error evaluating expression on exchange.").component(this.getDisplayName()).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        if (o instanceof List) {
            List l = (List)o;
            log.debug("List detected {}", (Object)l);
            for (Object o2 : l) {
                log.debug("type: {}, it: {}", o2.getClass(), o2);
                if (!flow.isRequest()) continue;
                exc.setProperty("it", o2);
                this.getFlowController().invokeRequestHandlers(exc, this.interceptors);
            }
        }
        return Outcome.CONTINUE;
    }

    public ExchangeExpression.Language getLanguage() {
        return this.language;
    }

    @MCAttribute
    public void setLanguage(ExchangeExpression.Language language) {
        this.language = language;
    }

    public String getIn() {
        return this.in;
    }

    @MCAttribute
    @Required
    public void setIn(String in) {
        this.in = in;
    }

    @Override
    public String getDisplayName() {
        return "for";
    }

    @Override
    public String getShortDescription() {
        StringBuilder ret = new StringBuilder("for (" + this.in + ") {");
        for (Interceptor i : this.getInterceptors()) {
            ret.append("<br/>&nbsp;&nbsp;&nbsp;&nbsp;").append(i.getDisplayName());
        }
        ret.append("<br/>}");
        return ret.toString();
    }
}

