/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.flow;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.flow.AbstractFlowInterceptor;
import com.predic8.membrane.core.lang.ExchangeExpression;
import com.predic8.membrane.core.lang.ExchangeExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="if")
public class IfInterceptor
extends AbstractFlowInterceptor {
    private static final Logger log = LoggerFactory.getLogger(IfInterceptor.class);
    private String test;
    private ExchangeExpression.Language language = ExchangeExpression.Language.SPEL;
    private ExchangeExpression exchangeExpression;

    public IfInterceptor() {
        this.name = "if";
    }

    @Override
    public void init() {
        super.init();
        this.exchangeExpression = ExchangeExpression.newInstance(this.router, this.language, this.test);
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        return this.handleInternal(exc, Interceptor.Flow.REQUEST);
    }

    @Override
    public Outcome handleResponse(Exchange exc) {
        return this.handleInternal(exc, Interceptor.Flow.RESPONSE);
    }

    private Outcome handleInternal(Exchange exc, Interceptor.Flow flow) {
        boolean result;
        try {
            result = this.exchangeExpression.evaluate(exc, flow, Boolean.class);
        }
        catch (ExchangeExpressionException e) {
            e.provideDetails(ProblemDetails.internal(this.router.isProduction(), this.getDisplayName())).detail("Error evaluating expression on exchange.").buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        catch (NullPointerException npe) {
            log.debug("Expression {} returned null and is therefore interpreted as false", (Object)this.test);
            result = false;
        }
        if (log.isDebugEnabled()) {
            log.debug("Expression {} evaluated to {}.", (Object)this.test, (Object)result);
        }
        if (!result) {
            return Outcome.CONTINUE;
        }
        return switch (flow) {
            case Interceptor.Flow.REQUEST -> this.getFlowController().invokeRequestHandlers(exc, this.getInterceptors());
            case Interceptor.Flow.RESPONSE -> this.getFlowController().invokeResponseHandlers(exc, this.getInterceptors());
            default -> throw new RuntimeException("Should never happen");
        };
    }

    public ExchangeExpression.Language getLanguage() {
        return this.language;
    }

    @MCAttribute
    public void setLanguage(ExchangeExpression.Language language) {
        this.language = language;
    }

    public String getTest() {
        return this.test;
    }

    @MCAttribute
    @Required
    public void setTest(String test) {
        this.test = test;
    }

    @Override
    public String getShortDescription() {
        StringBuilder ret = new StringBuilder("if (" + this.test + ") {");
        for (Interceptor i : this.getInterceptors()) {
            ret.append("<br/>&nbsp;&nbsp;&nbsp;&nbsp;").append(i.getDisplayName());
        }
        ret.append("<br/>}");
        return ret.toString();
    }
}

