/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.flow;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.flow.AbstractFlowInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="request", topLevel=false)
public class RequestInterceptor
extends AbstractFlowInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RequestInterceptor.class);

    public RequestInterceptor() {
        this.name = "request interceptor";
        this.setFlow(Interceptor.Flow.Set.REQUEST_FLOW);
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        for (Interceptor i : this.getInterceptors()) {
            if (!i.handlesRequests()) continue;
            log.debug("Invoking handler: {} on exchange: {}", (Object)i.getDisplayName(), (Object)exc);
            try {
                Outcome o = i.handleRequest(exc);
                if (o == Outcome.CONTINUE) continue;
                return o;
            }
            catch (Exception e) {
                RequestInterceptor.createProblemDetails("request", i, exc, e);
                return Outcome.ABORT;
            }
        }
        return Outcome.CONTINUE;
    }
}

