/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.flow;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.AbstractBody;
import com.predic8.membrane.core.http.Body;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.util.HttpUtil;
import java.io.IOException;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="return")
public class ReturnInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)ReturnInterceptor.class.getName());
    private int statusCode = 200;
    private String contentType = null;

    @Override
    public Outcome handleRequest(Exchange exc) {
        try {
            exc.setResponse(this.getOrCreateResponse(exc));
        }
        catch (IOException e) {
            String detail = "Could not create response!";
            log.error(detail, (Throwable)e);
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).detail(detail).exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        return Outcome.RETURN;
    }

    private Response getOrCreateResponse(Exchange exc) throws IOException {
        Response response = exc.getResponse();
        if (response == null) {
            response = this.createResponseFromRequest(exc);
        }
        if (this.statusCode != 0) {
            response.setStatusCode(this.statusCode);
            response.setStatusMessage(HttpUtil.getMessageForStatusCode(this.statusCode));
        }
        if (this.contentType != null) {
            response.getHeader().setContentType(this.contentType);
        }
        if (response.isBodyEmpty() && !response.getHeader().hasContentLength()) {
            response.getHeader().setContentLength(0L);
        }
        return response;
    }

    private Response createResponseFromRequest(Exchange exc) throws IOException {
        Response.ResponseBuilder builder = new Response.ResponseBuilder().status(this.statusCode);
        String reqContentType = exc.getRequest().getHeader().getContentType();
        if (reqContentType != null) {
            builder.contentType(reqContentType);
        }
        Response response = builder.build();
        AbstractBody abstractBody = exc.getRequest().getBody();
        if (abstractBody instanceof Body) {
            Body body = (Body)abstractBody;
            response.setBody(body);
            response.getHeader().setContentLength(body.getLength());
        }
        return response;
    }

    @Override
    public String getDisplayName() {
        return "return";
    }

    @Override
    public String getShortDescription() {
        return this.contentType != null ? String.format("Sends a response with a status code of %d and a content type of %s.", this.statusCode, this.contentType) : String.format("Sends a response with a status code of %d.", this.statusCode);
    }

    @MCAttribute
    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @MCAttribute
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Override
    public EnumSet<Interceptor.Flow> getFlow() {
        return Interceptor.Flow.Set.REQUEST_RESPONSE_ABORT_FLOW;
    }
}

