/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.flow.choice;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.flow.choice.InterceptorContainer;
import com.predic8.membrane.core.lang.ExchangeExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="case", topLevel=false)
public class Case
extends InterceptorContainer {
    private static final Logger log = LoggerFactory.getLogger(Case.class);
    private String test;
    private ExchangeExpression.Language language = ExchangeExpression.Language.SPEL;
    private ExchangeExpression exchangeExpression;

    public void init(Router router) {
        this.exchangeExpression = ExchangeExpression.newInstance(router, this.language, this.test);
    }

    boolean evaluate(Exchange exc, Interceptor.Flow flow) {
        boolean result = this.exchangeExpression.evaluate(exc, flow, Boolean.class);
        log.debug("Expression {} evaluated to {}.", (Object)this.test, (Object)result);
        return result;
    }

    public ExchangeExpression getExchangeExpression() {
        return this.exchangeExpression;
    }

    public ExchangeExpression.Language getLanguage() {
        return this.language;
    }

    @MCAttribute
    public void setLanguage(ExchangeExpression.Language language) {
        this.language = language;
    }

    public String getTest() {
        return this.test;
    }

    @MCAttribute
    @Required
    public void setTest(String test) {
        this.test = test;
    }
}

