/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.flow.choice;

import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.flow.AbstractFlowInterceptor;
import com.predic8.membrane.core.interceptor.flow.choice.Case;
import com.predic8.membrane.core.interceptor.flow.choice.InterceptorContainer;
import com.predic8.membrane.core.interceptor.flow.choice.Otherwise;
import com.predic8.membrane.core.lang.ExchangeExpressionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

@MCElement(name="choose")
public class ChooseInterceptor
extends AbstractFlowInterceptor {
    private final List<Case> cases = new ArrayList<Case>();
    private Otherwise otherwise;

    @Override
    public void init() {
        this.cases.forEach(c -> c.init(this.router));
        this.interceptors.addAll(Stream.concat(this.otherwise != null ? this.otherwise.getInterceptors().stream() : Stream.empty(), this.cases.stream().map(InterceptorContainer::getInterceptors).flatMap(Collection::stream)).toList());
        super.init();
    }

    public ChooseInterceptor() {
        this.name = "choose";
        this.setFlow(Interceptor.Flow.Set.REQUEST_RESPONSE_ABORT_FLOW);
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        return this.handleInternal(exc, Interceptor.Flow.REQUEST);
    }

    @Override
    public Outcome handleResponse(Exchange exc) {
        return this.handleInternal(exc, Interceptor.Flow.RESPONSE);
    }

    private Outcome handleInternal(Exchange exc, Interceptor.Flow flow) {
        return Optional.ofNullable(this.findTrueCase(exc, flow)).map(choice -> choice.invokeFlow(exc, flow, this.router)).orElseGet(() -> this.otherwise != null ? this.otherwise.invokeFlow(exc, flow, this.router) : Outcome.CONTINUE);
    }

    @Nullable
    private Case findTrueCase(Exchange exc, Interceptor.Flow flow) {
        try {
            for (Case c : this.cases) {
                if (!c.evaluate(exc, flow)) continue;
                return c;
            }
        }
        catch (ExchangeExpressionException e) {
            this.handleExpressionProblemDetails(e, exc);
        }
        return null;
    }

    private void handleExpressionProblemDetails(ExchangeExpressionException e, Exchange exc) {
        e.provideDetails(ProblemDetails.internal(this.router.isProduction(), this.getDisplayName())).addSubSee("expression-evaluation").detail("Error evaluating expression on exchange in if plugin.").buildAndSetResponse(exc);
    }

    public List<Case> getCases() {
        return this.cases;
    }

    @MCChildElement(order=1)
    public void setCases(List<Case> cases) {
        this.cases.addAll(cases);
    }

    public Otherwise getOtherwise() {
        return this.otherwise;
    }

    @MCChildElement(order=2)
    public void setOtherwise(Otherwise otherwise) {
        this.otherwise = otherwise;
    }

    @Override
    @MCChildElement(order=3, allowForeign=true)
    public void setInterceptors(List<Interceptor> interceptors) {
    }
}

