/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.flow.choice;

import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.lang.ExchangeExpressionException;
import java.util.List;

abstract class InterceptorContainer {
    private List<Interceptor> interceptors;

    InterceptorContainer() {
    }

    Outcome invokeFlow(Exchange exc, Interceptor.Flow flow, Router router) {
        try {
            return switch (flow) {
                case Interceptor.Flow.REQUEST -> router.getFlowController().invokeRequestHandlers(exc, this.interceptors);
                case Interceptor.Flow.RESPONSE -> router.getFlowController().invokeResponseHandlers(exc, this.interceptors);
                default -> throw new RuntimeException("Should never happen");
            };
        }
        catch (Exception e) {
            this.handleInvocationProblemDetails(exc, e, router);
            throw new ExchangeExpressionException("Error evaluating expression on exchange in if plugin.", e);
        }
    }

    private void handleInvocationProblemDetails(Exchange exc, Exception e, Router router) {
        ProblemDetails.internal(router.isProduction(), "interceptor-container").detail("Error invoking plugin.").exception(e).buildAndSetResponse(exc);
    }

    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    @MCChildElement(allowForeign=true)
    public void setInterceptors(List<Interceptor> interceptors) {
        this.interceptors = interceptors;
    }
}

