/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.formvalidation;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.Required;
import com.predic8.membrane.core.config.AbstractXmlElement;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.util.URLParamUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="formValidation")
public class FormValidationInterceptor
extends AbstractInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)FormValidationInterceptor.class.getName());
    private List<Field> fields = new ArrayList<Field>();

    public FormValidationInterceptor() {
        this.name = "form validation";
        this.setFlow(Interceptor.Flow.Set.REQUEST_FLOW);
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        Map<String, String> propMap;
        this.logMappings();
        try {
            propMap = URLParamUtil.getParams(this.router.getUriFactory(), exc, URLParamUtil.DuplicateKeyOrInvalidFormStrategy.ERROR);
        }
        catch (Exception e) {
            ProblemDetails.internal(this.router.isProduction(), this.getDisplayName()).detail("Could not parse query parameters!").topLevel("uri", exc.getRequest().getUri()).exception(e).buildAndSetResponse(exc);
            return Outcome.ABORT;
        }
        for (Field f : this.fields) {
            if (!propMap.containsKey(f.name) || f.matchesSubstring(propMap.get(f.name))) continue;
            this.setErrorResponse(exc, propMap, f);
            return Outcome.ABORT;
        }
        return Outcome.CONTINUE;
    }

    private void setErrorResponse(Exchange exc, Map<String, String> propMap, Field f) {
        exc.setResponse(Response.badRequest("Parameter " + f.name + "=" + propMap.get(f.name) + " didn't match " + f.regex).build());
    }

    private void logMappings() {
        for (Field m : this.fields) {
            log.debug("[regex:{}],[name:{}]", (Object)m.regex, (Object)m.name);
        }
    }

    public List<Field> getFields() {
        return this.fields;
    }

    @MCChildElement
    @Required
    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    @Override
    public String getDisplayName() {
        return "form validation";
    }

    @MCElement(name="field", topLevel=false, id="formValidation-field")
    public static class Field
    extends AbstractXmlElement {
        public String name;
        public String regex;
        private Pattern pattern;

        public boolean matchesSubstring(String input) {
            return this.pattern.matcher(input).matches();
        }

        @Override
        protected void parseAttributes(XMLStreamReader token) {
            this.name = token.getAttributeValue("", "name");
            this.setRegex(token.getAttributeValue("", "regex"));
        }

        @Override
        public void write(XMLStreamWriter out) throws XMLStreamException {
            out.writeStartElement("field");
            out.writeAttribute("regex", this.regex);
            out.writeAttribute("name", this.name);
            out.writeEndElement();
        }

        public String getName() {
            return this.name;
        }

        @MCAttribute
        @Required
        public void setName(String name) {
            this.name = name;
        }

        public String getRegex() {
            return this.regex;
        }

        @MCAttribute
        @Required
        public void setRegex(String regex) {
            this.regex = regex;
            this.pattern = Pattern.compile(regex);
        }
    }
}

