/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.grease;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.grease.strategies.Greaser;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;

@MCElement(name="greaser")
public class GreaseInterceptor
extends AbstractInterceptor {
    private final List<Greaser> strategies = new ArrayList<Greaser>();
    private final Random random = new Random();
    public static final String X_GREASE = "X-Grease";
    private double rate = 1.0;

    public GreaseInterceptor() {
        this.name = "grease";
        this.setFlow(EnumSet.of(Interceptor.Flow.REQUEST, Interceptor.Flow.RESPONSE));
    }

    private Message handleInternal(Message msg) {
        if (!this.shallGrease()) {
            return msg;
        }
        return this.strategies.stream().reduce(msg, (m, strategy) -> strategy.apply((Message)m), (ignored, ret) -> ret);
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        exc.setRequest((Request)this.handleInternal(exc.getRequest()));
        return Outcome.CONTINUE;
    }

    @Override
    public Outcome handleResponse(Exchange exc) {
        exc.setResponse((Response)this.handleInternal(exc.getResponse()));
        return Outcome.CONTINUE;
    }

    @MCAttribute
    public void setRate(String rate) {
        this.rate = Math.max(0.0, Math.min(1.0, Double.parseDouble(rate)));
    }

    public double getRate() {
        return this.rate;
    }

    @MCChildElement
    public void setStrategies(List<Greaser> strategies) {
        this.strategies.addAll(strategies);
    }

    public List<Greaser> getStrategies() {
        return this.strategies;
    }

    @Override
    public String getShortDescription() {
        return "Greases data like XML or JSON to stress test data inputs.";
    }

    private boolean shallGrease() {
        return this.rate > this.random.nextDouble();
    }
}

