/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.grease.strategies;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.MimeType;
import com.predic8.membrane.core.interceptor.grease.strategies.Greaser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="greaseJson", topLevel=false)
public class JsonGrease
extends Greaser {
    private static final ObjectMapper om = new ObjectMapper();
    private static final Logger log = LoggerFactory.getLogger(JsonGrease.class);
    boolean shuffleFields = true;
    boolean additionalProperties = true;

    @Override
    protected Message process(Message msg) {
        try {
            ObjectNode json = (ObjectNode)om.readTree(msg.getBody().getContentAsStream());
            if (this.additionalProperties) {
                JsonGrease.processJson(json, JsonGrease::injectField);
            }
            if (this.shuffleFields) {
                JsonGrease.processJson(json, JsonGrease::shuffleNodeFields);
            }
            msg.setBodyContent(om.writeValueAsBytes((Object)json));
            return msg;
        }
        catch (IOException e) {
            log.info("Failed to read JSON body ", (Throwable)e);
            return msg;
        }
    }

    @Override
    protected boolean isApplicable(Message msg) {
        return MimeType.isJson(msg.getHeader().getContentType());
    }

    @Override
    protected String getGreaseChanges() {
        return (this.shuffleFields ? "JSON fields shuffled" : "") + (this.shuffleFields && this.additionalProperties ? ", " : "") + (this.additionalProperties ? "Added random JSON fields" : "");
    }

    private static void injectField(ObjectNode node) {
        node.put("grease", "Field added by Membrane's Grease plugin");
    }

    static void processJson(ObjectNode jsonNode, Consumer<ObjectNode> action) {
        action.accept(jsonNode);
        jsonNode.fieldNames().forEachRemaining(fieldName -> {
            JsonNode childNode = jsonNode.get(fieldName);
            if (childNode.isObject()) {
                JsonGrease.processJson((ObjectNode)childNode, action);
            } else if (childNode.isArray()) {
                ArrayNode arrayNode = (ArrayNode)childNode;
                arrayNode.forEach(arrayElement -> {
                    if (arrayElement.isObject()) {
                        JsonGrease.processJson((ObjectNode)arrayElement, action);
                    }
                });
            }
        });
    }

    static void shuffleNodeFields(ObjectNode objectNode) {
        ArrayList fieldsOrdered = new ArrayList();
        objectNode.fieldNames().forEachRemaining(fieldsOrdered::add);
        ArrayList fields = new ArrayList(fieldsOrdered);
        while (fields.equals(fieldsOrdered)) {
            Collections.shuffle(fields);
        }
        ObjectNode shuffledNode = om.createObjectNode();
        for (String field : fields) {
            shuffledNode.set(field, objectNode.get(field));
        }
        objectNode.removeAll();
        objectNode.setAll(shuffledNode);
    }

    @MCAttribute
    public void setAdditionalProperties(boolean additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    @MCAttribute
    public void setShuffleFields(boolean shuffleFields) {
        this.shuffleFields = shuffleFields;
    }

    public boolean isAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean isShuffleFields() {
        return this.shuffleFields;
    }
}

