/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.groovy;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.lang.AbstractScriptInterceptor;
import com.predic8.membrane.core.lang.groovy.GroovyLanguageSupport;
import com.predic8.membrane.core.util.ConfigurationException;
import com.predic8.membrane.core.util.TextUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.EnumSet;
import org.apache.commons.text.StringEscapeUtils;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.messages.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="groovy", mixed=true)
public class GroovyInterceptor
extends AbstractScriptInterceptor {
    private static final Logger log = LoggerFactory.getLogger(GroovyInterceptor.class);

    public GroovyInterceptor() {
        this.name = "groovy";
    }

    @Override
    public EnumSet<Interceptor.Flow> getFlow() {
        return Interceptor.Flow.Set.REQUEST_RESPONSE_ABORT_FLOW;
    }

    @Override
    protected void initInternal() {
        try {
            this.script = new GroovyLanguageSupport().compileScript(this.router.getBackgroundInitializer(), null, this.src);
        }
        catch (MultipleCompilationErrorsException e) {
            this.logGroovyError(e);
            throw new ConfigurationException("Error in Groovy script initialization.", e);
        }
    }

    private void logGroovyError(MultipleCompilationErrorsException e) {
        log.error("Error in Groovy script in API '{}' with source: {}", (Object)this.getProxy().getName(), (Object)this.src);
        for (Message error : e.getErrorCollector().getErrors()) {
            ByteArrayOutputStream bais = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(bais);
            error.write(pw);
            pw.flush();
            log.error("Error message: {}", (Object)bais);
        }
    }

    @Override
    public String getShortDescription() {
        return "Executes a groovy script.";
    }

    @Override
    public String getLongDescription() {
        return String.valueOf(TextUtil.removeFinalChar(this.getShortDescription())) + ":<br/><pre style=\"overflow-x:auto\">" + StringEscapeUtils.escapeHtml4((String)this.src.stripIndent()) + "</pre>";
    }
}

