/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.groovy;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.MCTextContent;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.interceptor.AbstractInterceptor;
import com.predic8.membrane.core.interceptor.Outcome;
import com.predic8.membrane.core.interceptor.groovy.GroovyInterceptor;
import org.springframework.web.util.HtmlUtils;

@MCElement(name="groovyTemplate", mixed=true)
public class GroovyTemplateInterceptor
extends AbstractInterceptor {
    String src = "";
    GroovyInterceptor groovyInterceptor;

    public GroovyTemplateInterceptor() {
        this.name = "groovy template";
    }

    @Override
    public void init() {
        super.init();
        this.groovyInterceptor = new GroovyInterceptor();
        this.groovyInterceptor.setSrc(this.createGroovyScript());
        this.groovyInterceptor.init(this.router);
    }

    @Override
    public Outcome handleRequest(Exchange exc) {
        this.groovyInterceptor.handleRequest(exc);
        String html = (String)exc.getProperty("GROOVY_TEMPLATE");
        exc.setResponse(Response.ok(html).contentType("text/html;charset=UTF-8").build());
        return Outcome.RETURN;
    }

    private String createGroovyScript() {
        return "import groovy.text.markup.*\ndef markupEngine = new MarkupTemplateEngine()\ndef writer = new StringWriter()\ndef markup = '''%s'''\ndef output = markupEngine.createTemplate(markup).make(['spring':spring, 'exc':exc,'flow':flow]).writeTo(writer)\nexc.setProperty('GROOVY_TEMPLATE',output.toString())\nCONTINUE".formatted(this.src);
    }

    public String getSrc() {
        return this.src;
    }

    @MCTextContent
    public void setSrc(String src) {
        this.src = src;
    }

    @Override
    public String getShortDescription() {
        return "Responds with the result of a Groovy Template.";
    }

    @Override
    public String getLongDescription() {
        return "<div>Responds with the result of a the Groovy Template (see <a href=\"https://docs.groovy-lang.org/docs/next/html/documentation/template-engines.html#_the_markuptemplateengine\">MarkupTemplateEngine</a>):<br/><br/><pre>" + HtmlUtils.htmlEscape((String)this.src.stripIndent()) + "</pre></div>";
    }
}

