/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.javascript;

import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.interceptor.javascript.LanguageAdapter;
import com.predic8.membrane.core.lang.javascript.GraalVMJavascriptSupport;
import org.graalvm.polyglot.PolyglotException;

public class GraalVMJavascriptLanguageAdapter
extends LanguageAdapter {
    public GraalVMJavascriptLanguageAdapter(Router router) {
        super(router);
        this.languageSupport = new GraalVMJavascriptSupport();
    }

    @Override
    public ProblemDetails getProblemDetails(Exception e) {
        ProblemDetails pd = ProblemDetails.internal(this.router.isProduction(), "javascript");
        if (e instanceof PolyglotException) {
            PolyglotException pe = (PolyglotException)((Object)e);
            pd.internal("column", pe.getSourceLocation().getStartColumn());
            pd.internal("line", pe.getSourceLocation().getStartLine() - preScriptLineLength);
            pd.internal("engine", "graal");
            pd.exception(pe);
        }
        return pd;
    }

    @Override
    protected String getPreScript() {
        return "var FileClass = Java.type(\"java.io.File\");\nvar Request = Java.type(\"com.predic8.membrane.core.http.Request\");\nvar Response = Java.type(\"com.predic8.membrane.core.http.Response\");\n";
    }
}

