/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.javascript;

import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.interceptor.javascript.LanguageAdapter;
import com.predic8.membrane.core.lang.AbstractScriptInterceptor;
import com.predic8.membrane.core.util.ConfigurationException;
import com.predic8.membrane.core.util.TextUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MCElement(name="javascript", mixed=true)
public class JavascriptInterceptor
extends AbstractScriptInterceptor {
    private static final Logger log = LoggerFactory.getLogger(JavascriptInterceptor.class);
    protected LanguageAdapter adapter;

    public JavascriptInterceptor() {
        this.name = "javascript";
    }

    @Override
    protected void initInternal() {
        if (this.adapter == null) {
            this.adapter = LanguageAdapter.instance(this.router);
        }
        try {
            this.script = this.adapter.compileScript(this.src);
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not compile: \n" + this.src, e);
        }
    }

    @Override
    public String getShortDescription() {
        return "Executes Javascript.";
    }

    @Override
    public String getLongDescription() {
        return String.valueOf(TextUtil.removeFinalChar(this.getShortDescription())) + ":<br/><pre style=\"overflow-x:auto\">" + StringEscapeUtils.escapeHtml4((String)this.src.stripIndent()) + "</pre>";
    }

    @Override
    protected void handleScriptExecutionException(Exchange exc, Exception e) {
        log.warn("Error executing {} script: {}", (Object)this.name, (Object)e.getMessage());
        log.warn("Script: {}", (Object)this.src);
        ProblemDetails pd = this.adapter.getProblemDetails(e);
        pd.title("Error executing script.");
        pd.internal("source", StringUtils.trim((String)this.src));
        exc.setResponse(pd.build());
    }
}

