/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.interceptor.javascript;

import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.exceptions.ProblemDetails;
import com.predic8.membrane.core.interceptor.javascript.LanguageAdapter;
import com.predic8.membrane.core.lang.javascript.RhinoJavascriptLanguageSupport;
import javax.script.ScriptException;

public class RhinoJavascriptLanguageAdapter
extends LanguageAdapter {
    public RhinoJavascriptLanguageAdapter(Router router) {
        super(router);
        this.languageSupport = new RhinoJavascriptLanguageSupport();
    }

    @Override
    public ProblemDetails getProblemDetails(Exception e) {
        ProblemDetails pd = ProblemDetails.internal(this.router.isProduction(), "javascript");
        Throwable throwable = e.getCause();
        if (throwable instanceof ScriptException) {
            ScriptException se = (ScriptException)throwable;
            pd.internal("column", se.getColumnNumber() + 1);
            pd.internal("line", se.getLineNumber() - preScriptLineLength + 1);
            pd.internal("message", se.getMessage());
            pd.internal("engine", "rhino");
        }
        return pd;
    }

    @Override
    protected String getPreScript() {
        return "var imports = new JavaImporter(com.predic8.membrane.core.interceptor.Outcome, com.predic8.membrane.core.http)\nvar console = {};\nconsole.log = function(s) {\n  java.lang.System.out.println(new java.lang.String(s));\n};\nvar json;\nif (message.isJSON()) {\n  json=JSON.parse(message.getBodyAsStringDecoded());\n}\nwith(imports) {\n";
    }

    @Override
    protected String getPostScript() {
        return "};\n";
    }
}

